        --
        DO $f$ -- Funktionsdummy für Trigger Enable
         BEGIN
          IF NOT EXISTS(SELECT true FROM pg_proc WHERE proname = 'triggers__all__enable') THEN
             EXECUTE $e$
            CREATE FUNCTION tsystem.triggers__all__enable() RETURNS VOID AS $$ --dummy daher kein or replace
             BEGIN
              return;
             END $$ LANGUAGE plpgsql;     
             $e$;
           END IF;
         END $f$;
        --
        SELECT TSystem.triggers__all__enable();
        --
        -- gme (uf1) / gwaer (basis_w) sind immer berechnete Felder und niemals Eingabefelder
        
        --
        -- https://redmine.prodat-sql.de/projects/prodat-v12-public/wiki/TSystem_Wawi
        --
        DROP SCHEMA IF EXISTS TSystem_Wawi CASCADE; --Grundtabellen für Warenwirtschaft erstellen, nur Templates, niemals Daten
        
        CREATE SCHEMA TSystem_Wawi; --Grundtabellen für Warenwirtschaft erstellen, nur Templates, niemals Daten
        
        
        
        CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__trigger__totalposwert__disable() RETURNS VOID AS $$
            DECLARE varname VARCHAR;
            BEGIN
             IF current_user='syncro' THEN
                    RETURN;
             END IF;
             varname:=current_user||'TSystem_Wawi.beleg_p__trigger__totalposwert';
             PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)+1 AS VARCHAR));
             PERFORM disablemodified();
             RETURN;
            END $$ LANGUAGE plpgsql;
        
        CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__trigger__totalposwert__enable() RETURNS VOID AS $$
            DECLARE varname VARCHAR;
            BEGIN
             IF current_user='syncro' THEN
                    RETURN;
             END IF;
             varname:=current_user||'TSystem_Wawi.beleg_p__trigger__totalposwert';
             PERFORM TSystem.Settings__Set(varname, CAST(TSystem.Settings__GetInteger(varname)-1 AS VARCHAR));
             PERFORM enablemodified();
             RETURN;
            END $$ LANGUAGE plpgsql;
        
        CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__trigger__totalposwert__disabled__is() RETURNS BOOL AS $$
            DECLARE varname VARCHAR;
            BEGIN
             varname:=current_user||'TSystem_Wawi.beleg_p__trigger__totalposwert';
             RETURN TSystem.Settings__GetInteger(varname)>0;
            END$$LANGUAGE plpgsql;
        
        --
        
        CREATE TABLE TSystem_Wawi.beleg_k__belart ( 
         kba_id                    SERIAL NOT NULL UNIQUE, --ACHTUNG: Primary Key über Index unten. Sinnvoll????
         kba_tablename             VARCHAR(50) NOT NULL, --PK
         kba_beld_typ_oldstructure VARCHAR(20),
         kba_key                   VARCHAR(15) NOT NULL, --PK
         kba_pos                   INTEGER,
         -- kba_code               ?? R, E, A usw?
         kba_bez                   VARCHAR(75),
         kba_default               BOOLEAN,
         
         dbrid                     VARCHAR(32) UNIQUE NOT NULL DEFAULT nextval('db_id_seq'),
         insert_date               DATE,
         insert_by                 VARCHAR(32),
         modified_date             TIMESTAMP(0),
         modified_by               VARCHAR(32)     
         );
         CREATE UNIQUE INDEX beleg_k__belart__ident_tablename ON TSystem_Wawi.beleg_k__belart(kba_tablename, kba_key);
         ALTER TABLE TSystem_Wawi.beleg_k__belart ADD CONSTRAINT beleg_k__belart_pkey PRIMARY KEY USING INDEX beleg_k__belart__ident_tablename;
        -- TODO: entfernen und in Vorgaben
        INSERT INTO TSystem_Wawi.beleg_k__belart(kba_key, kba_tablename, kba_bez, kba_beld_typ_oldstructure)
            VALUES (1, 'rechnunge', 'RECHNUNG', 'ERG'), (2, 'rechnunge', 'GUTSCHRIFT', 'ERG');  -- Todo aus belart übertragen bzw. Vorgaben
        INSERT INTO TSystem_Wawi.beleg_k__belart (kba_key, kba_tablename, kba_bez, kba_beld_typ_oldstructure)
            VALUES (3, 'lieferscheinv', 'Lieferschein', 'LFS'), (4, 'lieferscheinv', 'Retourenlieferschein', 'LFS'), (6, 'lieferscheinv', 'Beistell-Lieferschein', 'LFS');
        INSERT INTO TSystem_Wawi.beleg_k__belart(kba_key, kba_tablename, kba_bez, kba_beld_typ_oldstructure) 
            VALUES (5, 'lieferantenursprungse', 'Lieferanten-Ursprungserklärung', 'LUE');
    
        INSERT INTO TSystem_Wawi.beleg_k__belart(kba_key, kba_tablename, kba_bez) --rechnungv
            VALUES (1, 'rechnungv', 'RECHNUNG'), (2, 'rechnungv', 'GUTSCHRIFT'), (3, 'rechnungv', 'Proforma-Rechnung'), (4, 'rechnungv', 'Anzahlungsrechnung'), 
                    (5, 'rechnungv', 'Aufmaß'), (6, 'rechnungv', 'Abschlagsrechnung kumuliert'), (7, 'rechnungv', 'Abschlagsrechnung'), (10, 'rechnungv', 'Schlussrechnung'),
                    (11, 'rechnungv', 'Storno-Rechnung'), (12, 'rechnungv', 'Rechnungskorrektur')                    
                   ;
        
        INSERT INTO TSystem_Wawi.beleg_k__belart(kba_tablename, kba_key, kba_pos, kba_bez) VALUES ('artchange','Frei'  ,10, 'Frei');
        INSERT INTO TSystem_Wawi.beleg_k__belart(kba_tablename, kba_key, kba_pos, kba_bez) VALUES ('artchange','NT'    ,20, 'Neuteil');
        INSERT INTO TSystem_Wawi.beleg_k__belart(kba_tablename, kba_key, kba_pos, kba_bez) VALUES ('artchange','EC'    ,30, 'Artikeländerung');
        INSERT INTO TSystem_Wawi.beleg_k__belart(kba_tablename, kba_key, kba_pos, kba_bez) VALUES ('artchange','PC'    ,40, 'Prozessänderung zum Artikel');
        INSERT INTO TSystem_Wawi.beleg_k__belart(kba_tablename, kba_key, kba_pos, kba_bez) VALUES ('artchange','PCzEC' ,50, 'Prozessänderung zur Artikeländerung');  

        -- Übersetzungen / Spracheinträge 
         -- Übersetzungen für Belegarten
          CREATE TABLE TSystem_Wawi.beleg_k__belart__languages (
            kbal_id              SERIAL PRIMARY KEY,
            kbal_kba_id          INTEGER    NOT NULL REFERENCES TSystem_Wawi.beleg_k__belart(kba_id) ON UPDATE CASCADE ON DELETE CASCADE,
            kbal_spr_key         VARCHAR(5) NOT NULL REFERENCES sprach,
            kbal_txt             VARCHAR(50)
           );
          --
          CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__belart__a_iud__languages() RETURNS TRIGGER AS $$
           BEGIN
            IF NOT tg_op='INSERT' THEN
                DELETE FROM TSystem_Wawi.beleg_k__belart__languages WHERE kbal_kba_id = old.kba_id AND kbal_spr_key = prodat_languages.current_lang();
            END IF;
            IF NOT tg_op='DELETE' THEN
                INSERT INTO TSystem_Wawi.beleg_k__belart__languages (kbal_kba_id, kbal_spr_key, kbal_txt) VALUES (new.kba_id, prodat_languages.current_lang(), new.kba_bez);
            END IF;
            RETURN new;
           END $$ LANGUAGE plpgsql;
          
           CREATE TRIGGER beleg_k__belart__a_iud__languages
            AFTER INSERT OR UPDATE OR DELETE
            ON TSystem_Wawi.beleg_k__belart
            FOR EACH ROW
            EXECUTE PROCEDURE TSystem_Wawi.beleg_k__belart__a_iud__languages();
          --
          CREATE UNIQUE INDEX beleg_k__belart_unique ON TSystem_Wawi.beleg_k__belart__languages (kbal_kba_id, kbal_spr_key);
         --
        DROP VIEW IF EXISTS z_99_deprecated.belegart; -- TODO; Klassen DROP
        CREATE OR REPLACE VIEW z_99_deprecated.belegart AS
         SELECT 
           AsNumeric(kba_key)::INTEGER       AS bela_id,
           kba_beld_typ_oldstructure         AS bela_beld_typ,
           kba_bez                           AS bela_bez,
           
           dbrid
         FROM
           TSystem_Wawi.beleg_k__belart
         WHERE
           kba_beld_typ_oldstructure IS NOT NULL; 
        
        DROP VIEW IF EXISTS z_99_deprecated.belegtyp;
        CREATE OR REPLACE VIEW z_99_deprecated.belegtyp AS 
         SELECT
           NULL::VARCHAR            AS belt_typ, 
           NULL::VARCHAR            AS belt_bezeichnung,
           NULL::BOOLEAN            AS belt_multipledok, 
           NULL::BOOLEAN            AS belt_eingangsseitig, 
           NULL::BOOLEAN            AS belt_ausgangsseitig, 
           NULL::BOOLEAN            AS belt_zahlfaehig, 
           NULL::BOOLEAN            AS belt_preiscalc,
           
           NULL::VARCHAR            AS dbrid,
           NULL::DATE               AS insert_date,
           NULL::VARCHAR            AS insert_by,
           NULL::TIMESTAMP(0)       AS modified_date,
           NULL::VARCHAR            AS modified_by
         ;
           
        --
        DROP VIEW IF EXISTS z_99_deprecated.belart;
        CREATE OR REPLACE VIEW z_99_deprecated.belart AS
         SELECT
           AsNumeric(kba_key)::INTEGER       AS ba_id,
           kba_bez                           AS ba_bez,
           
           NULL::VARCHAR            AS dbrid,
           NULL::DATE               AS insert_date,
           NULL::VARCHAR            AS insert_by,
           NULL::TIMESTAMP(0)       AS modified_date,
           NULL::VARCHAR            AS modified_by
         FROM
           TSystem_Wawi.beleg_k__belart
         WHERE
           kba_tablename = 'rechnungv';        
        --
        
        
        --
        CREATE TABLE TSystem_Wawi.beleg_k (
         k_id                      SERIAL         PRIMARY KEY,
         k_id_oldstructure         INTEGER,
         k_tablename               VARCHAR(50),   --auftg, ldsdok usw
         k_kba_key                 VARCHAR(5),		  -- REFERENCES TSystem_Wawi.beleg_k__belart (k_tablename, k_kba_key) = (kba_tablename, kba_ident), >> Constraints Create
         
         k_code                    VARCHAR(3),
         k_nummer                  VARCHAR(30)    NOT NULL UNIQUE,
          
         k_titel                   VARCHAR(75),
         k_erfasst_datum           DATE           DEFAULT current_date,  -- <> insert_date
         
         k_ad_krz                  VARCHAR(30)    NOT NULL REFERENCES adressen_keys ON UPDATE CASCADE,
         -- TODO: Liefer bzw. Abweichende wirksame Adresse 
        
         --
         
         k_txt_anschr              TEXT,
         k_txt_anschr_rtf          TEXT,
         k_txt_schluss             TEXT,
         k_txt_schluss_rtf         TEXT, 
         k_txt_int                 TEXT,
         
         k_definitiv               BOOLEAN NOT NULL DEFAULT false,
         k_print                   BOOLEAN NOT NULL DEFAULT false,
         
         dbrid                     VARCHAR(32) UNIQUE NOT NULL DEFAULT nextval('db_id_seq'),
         insert_date               DATE,
         insert_by                 VARCHAR(32),
         modified_date             TIMESTAMP(0),
         modified_by               VARCHAR(32) 
         );
        
        CREATE TABLE TSystem_Wawi.beleg_k__preise (
         k_wert_netto                   	NUMERIC(16,4), -- 		NOT NULL,
         k_wert_netto_gwaer             	NUMERIC(20,8), -- 		NOT NULL,
         k_wert_abzu_netto              	NUMERIC(16,4), -- 		NOT NULL,
         k_wert_abzu_netto_gwaer        	NUMERIC(20,8), -- 		NOT NULL,
         k_wert_abzuk_netto              	NUMERIC(16,4), -- 		NOT NULL,
         k_wert_abzuk_netto_gwaer        	NUMERIC(20,8), -- 		NOT NULL,
         k_wert_tot_netto              		NUMERIC(16,4), -- 		NOT NULL,
         k_wert_tot_netto_gwaer        		NUMERIC(20,8)  -- 		NOT NULL
         ) INHERITS (TSystem_Wawi.beleg_k);
        
        CREATE TABLE TSystem_Wawi.beleg_k__extend_wawi_ansprechpartner
         (
          -- Ansprechpartner Intern...Standard aus erster Position Bestellung, sonst current_user => ldsdok__a_iu() -- REFERENCES llv(ll_db_usename) ON UPDATE CASCADE siehe X TableContraints
          k_apext                    VARCHAR(50),
          k_apext_ap_krzl            VARCHAR(50),  --adkap
          
          k_apint_db_usename1        VARCHAR(50) DEFAULT tsystem.current_user_ll_db_usename(), 
          k_apint_db_usename2        VARCHAR(50), --REFERNCES
          
          k_pruef_db_usename1        VARCHAR(50), -- TODO REFERENCES llv(ll_db_usename) ON UPDATE CASCADE, --Prüfer
          k_pruef_db_usename1_real   VARCHAR(30), -- REFERENCES llv(ll_db_usename) ON UPDATE CASCADE,  -- Mitarbeiternummer von dem, der tatsächlich geprüft hat(kann ja auch Vertreter gewesen sein)
          k_pruef_freigabe1          BOOLEAN NOT NULL DEFAULT FALSE,
          k_pruef_freigabe_datum1    DATE
         );
        CREATE TABLE TSystem_Wawi.beleg_k__versand (
         k_versand_v_id                        INTEGER REFERENCES versart,       -- Versandart
         k_versand_bem                         VARCHAR(100),                     -- Versandart / Freitext    
         k_versand_ort_adkrz                   VARCHAR(30) REFERENCES adressen_keys ON UPDATE CASCADE,
         k_versand_txt                     	TEXT,
         k_versand_txt_rtf                 	TEXT 
         );
         
        CREATE TABLE TSystem_Wawi.beleg_k__preise_steu_zahlung (
         k_waer                         	VARCHAR(3)      	NOT NULL DEFAULT TSystem.Settings__Get('BASIS_W'), 
         k_waer_kurs                    	NUMERIC(6,2)    	NOT NULL DEFAULT 1, -- TODO TRIGGER muß anhand Währung ziehen
         k_rund_faktor                  	NUMERIC(8,2)    	NOT NULL DEFAULT 1, --Schweiz 0.5
         
         k_steu_code                    	INTEGER REFERENCES steutxt,
         k_steu_proz                    	NUMERIC(6,2)   		NOT NULL DEFAULT 0,
         
         k_rabatt_gesamt                	NUMERIC(6,2),       -- Gesamtrabatt für Bestellungen eines Einkaufsdokumente 
         
         k_zak_zahlziel_d               	INTEGER,            -- Zahlungsziel (in Tagen)
         k_zak_skonto_verf_d            	INTEGER,            -- Skonto verfällt nach X Tagen
         k_zak_skonto_proz              	NUMERIC(5,2),       -- Skontosatz
         k_zak_bem                      	VARCHAR(75),
         k_zak_zahlart_za_id            	INTEGER REFERENCES  zahlart ON UPDATE CASCADE,
         
         k_zak_kto_name                 	VARCHAR(100) 		REFERENCES ktovz ON UPDATE CASCADE,  --Bankkontenverzeichnis
         k_zak_zahlung_erledigt         	BOOLEAN 			NOT NULL DEFAULT FALSE,
    
         k_wert_brutto                  	NUMERIC(16,4), -- 		NOT NULL,
         k_wert_brutto_gwaer            	NUMERIC(20,8), -- 		NOT NULL,                                                                     
         k_wert_abzu_brutto             	NUMERIC(16,4), -- 		NOT NULL,
         k_wert_abzu_brutto_gwaer       	NUMERIC(20,8), -- 		NOT NULL,                                                                     
         k_wert_abzuk_brutto             	NUMERIC(16,4), -- 		NOT NULL,
         k_wert_abzuk_brutto_gwaer       	NUMERIC(20,8), -- 		NOT NULL,                                                                     
         k_wert_tot_brutto             		NUMERIC(16,4), -- 		NOT NULL,
         k_wert_tot_brutto_gwaer       		NUMERIC(20,8)  -- 		NOT NULL
         ) INHERITS (TSystem_Wawi.beleg_k__preise, TSystem_Wawi.beleg_k__versand, TSystem_Wawi.beleg_k__extend_wawi_ansprechpartner);
        
        
        CREATE TABLE TSystem_Wawi.beleg_k__mahnung (
          k_mahn_stufe              INTEGER,
          k_mahn_sperre             BOOL NOT NULL DEFAULT FALSE,
          k_mahn_erfasst_datum      DATE
          -- Referenz auf Mahntabelle? Klärung. > Einkauf > Mahnung Anschreiben und Schlußtext? > Klärung einfach neuer BelegKopf mit angemahnten Positionen?
         );
         
        CREATE TABLE TSystem_Wawi.beleg_k__export_zoll (
          k_zoll_export_txt             TEXT,
          k_zoll_export_txt_rtf         TEXT,
          k_zoll_ursprungs_txt          TEXT,
          k_zoll_ursprungs_txt_rtf      TEXT--,
          --k_zoll_ursprungsland_l_iso    
         );
        /*CREATE TABLE TSystem_Wawi.beleg_k__buchhaltung ( --???
         kbh_datum_valuta           DATE,
         kbh_datum_export           DATE,
         kbh_buchmonth              VARCHAR(6)                              -- Buchungszeitraum Format 'MMYYYY' Bsp: 022016 für Februar 2016
         );*/
        --
        CREATE TABLE TSystem_Wawi.beleg_x__allgfields_varchar(
          x_allgv1            VARCHAR(100),
          x_allgv2            VARCHAR(100),
          x_allgv3            VARCHAR(100),
          x_allgv4            VARCHAR(100),
          x_allgv5            VARCHAR(100),
          x_allgv6            VARCHAR(100),
          x_allgv7            VARCHAR(100)
         );
         
        CREATE TABLE TSystem_Wawi.beleg_x__allgfields_numeric(
          x_allgn1            NUMERIC(12,2),
          x_allgn2            NUMERIC(12,2),
          x_allgn3            NUMERIC(12,2),
          x_allgn4            NUMERIC(12,2),
          x_allgn5            NUMERIC(12,2),
          x_allgn6            NUMERIC(12,2),
          x_allgn7            NUMERIC(12,2)
         );
         
        CREATE TABLE TSystem_Wawi.beleg_x__allgfields(
         ) INHERITS (TSystem_Wawi.beleg_x__allgfields_varchar, TSystem_Wawi.beleg_x__allgfields_numeric);
         
         
        
        -- CREATE TABLE TSystem_Wawi.beleg_mahnung ( Kopftabelle für Mahnungen?
        
        CREATE TABLE TSystem_Wawi.beleg_p (
         p_id                      SERIAL         PRIMARY KEY,
         p_id_oldstructure         INTEGER,
         p_k_id                    INTEGER        NOT NULL REFERENCES TSystem_Wawi.beleg_k ON DELETE CASCADE,
         p_tablename               VARCHAR(50),   --auftg, ldsdok usw
         
         p_k_code                  VARCHAR(3),
         p_k_nummer                VARCHAR(30),   -- Feld für Kompatibilität: holt sich selbstständig anhand der Nummer die Verknüpfung (p_b_id) IMMER NULL
         
         p_erfasst_datum           DATE           DEFAULT current_date,       -- <> insert_date
         p_pos                     INTEGER        NOT NULL,
         p_parent_pos              INTEGER        CONSTRAINT beleg_p__parentpos__xtt11104 CHECK(p_pos IS DISTINCT FROM p_parent_pos), --
         p_parent_p_id             INTEGER        REFERENCES TSystem_Wawi.beleg_p, --id hpos
         p_pos_strukturpos         VARCHAR(30),   --1.1.2
         
         p_done                    BOOL           NOT NULL DEFAULT FALSE,
         p_done_datum              DATE,
         p_storno                  BOOL           NOT NULL DEFAULT FALSE,
         p_storno_datum            DATE,
         p_sperr                   BOOL           NOT NULL DEFAULT FALSE, --#9640 #9755 #9197
         
         p_apext                   VARCHAR(50),
         p_apext_ap_krzl           VARCHAR(50),   --adkap 
         p_apint_db_usename        VARCHAR(50)    DEFAULT tsystem.current_user_ll_db_usename(), 
         
         p_status_enum             TEXT,
         
         p_txt                     TEXT,
         p_txt_rtf                 TEXT,
         p_txt_int                 TEXT,
         p_txt_int_rtf             TEXT,
         
         dbrid                     VARCHAR(32) UNIQUE NOT NULL DEFAULT nextval('db_id_seq'),
         insert_date               DATE,
         insert_by                 VARCHAR(32),
         modified_date             TIMESTAMP(0),
         modified_by               VARCHAR(32)  
         );
        
        CREATE TABLE TSystem_Wawi.beleg_p__art (
         p_aknr                     VARCHAR(40)    REFERENCES art ON UPDATE CASCADE,
         p_ak_idx                   VARCHAR(30),
         p_ak_bez                   VARCHAR(100),
         p_aknr_referenz            VARCHAR(60)
         ) INHERITS (TSystem_Wawi.beleg_p); --??
         
        CREATE TABLE TSystem_Wawi.beleg_p__art_menge (
         p_menge                    NUMERIC(14,6)  NOT NULL,
         p_menge_gme                NUMERIC(14,6), --uf1?
         p_me                       INTEGER        REFERENCES artmgc ON UPDATE CASCADE
         ) INHERITS (TSystem_Wawi.beleg_p__art);
        
        CREATE TABLE TSystem_Wawi.beleg_p__art_frei (
         p_aknr_frei                VARCHAR(40), --darf es nur mit richtiger artikelnummer in zusammenhang geben. Felder werden syncron gehalten, wenn es eine richtige artikelnummer ist
         p_me_mgcode                INTEGER REFERENCES mgcode ON UPDATE CASCADE,
         p_me_bez                   VARCHAR(20)  
         );
         
        
        CREATE TABLE TSystem_Wawi.beleg_p__preise_base (
          p_preis                  	NUMERIC(20,8),    -- Preis ohne Preiseinheit (1)
          p_preis_gwaer            	NUMERIC(20,8),    -- basis_w?
          p_preis_gme_gwaer        	NUMERIC(20,8),  
          
          p_wert_netto             	NUMERIC(16,4), --     NOT NULL, -- damit sum usw nicht auf null triftt muß 0
          p_wert_netto_gwaer       	NUMERIC(20,8), --     NOT NULL, -- Totalwerte für Grundwährung bereits hier, damit Statistiken einheitlich sind. Wenn es keine Währung gibt, sind wir in der Grundwährung und die Felder werden im Trigger syncron gehalten
          p_wert_abzu_netto         NUMERIC(16,4), --     NOT NULL, 
          p_wert_abzu_netto_gwaer  	NUMERIC(20,8), --     NOT NULL, 
          p_wert_tot_netto        	NUMERIC(16,4), --     NOT NULL,       
          p_wert_tot_netto_gwaer  	NUMERIC(20,8)  --     NOT NULL
          
          -- Klärung ob ausgliedern (inkl parent_pos usw)
          ,p_preis_sumsubpos        	BOOLEAN           DEFAULT FALSE --reqquires hpos    --vkptotalpos
          ,p_nstatistik             	BOOLEAN           NOT NULL DEFAULT FALSE     
         ) INHERITS (TSystem_Wawi.beleg_p, TSystem_Wawi.beleg_p__art_menge);
         --
        CREATE TABLE TSystem_Wawi.beleg_p__preise_pe (
          p_preis_in_pe            	NUMERIC(12,4)     NOT NULL, -- u_preis_in_pe bzw. user_preis_in_pe ??  > > Richard
          p_preis_pe               	NUMERIC(12,4)     NOT NULL DEFAULT 1,  --Preiseinheit
          p_preis_me               	INTEGER           REFERENCES artmgc ON UPDATE CASCADE,
          p_preis_gme              	NUMERIC(20,8)     -- 100 Stück zu 5€ / 20 kg
         ) INHERITS (TSystem_Wawi.beleg_p__preise_base);
         --
        CREATE TABLE TSystem_Wawi.beleg_p__preise_rabatt (
          p_rabatt                 	NUMERIC(6,2)      NOT NULL DEFAULT 0,
          p_rabatt_gesamt          	NUMERIC(6,2),     --Nur intern zur Verrechnung, wird immer und ausschliesslich über beleg_k weitergegeben  
          p_rabatt_hint            	VARCHAR(200),
          p_rabatt_able            	BOOL              NOT NULL DEFAULT TRUE,
          p_preis_rabattiert        NUMERIC(20,8)
         ) INHERITS (TSystem_Wawi.beleg_p__preise_base);
         --
        CREATE TABLE TSystem_Wawi.beleg_p__preise_waer (  
          p_waer                   	VARCHAR(3)        NOT NULL REFERENCES bewa ON UPDATE CASCADE,  -- Default aus Kopf
          p_waer_kurs              	NUMERIC(6,2)      NOT NULL  -- Default aus Kopf
         ) INHERITS (TSystem_Wawi.beleg_p__preise_base);
         --
        CREATE TABLE TSystem_Wawi.beleg_p__preise_steu_brutto (
          p_steu_code              	INTEGER           REFERENCES steutxt ON UPDATE CASCADE,
          p_steu_proz              	NUMERIC(6,2)      NOT NULL DEFAULT 0,
          
          p_wert_brutto            	NUMERIC(16,4), --     NOT NULL, --damit sum usw nicht auf null triftt muß 0
          p_wert_brutto_gwaer      	NUMERIC(20,8), --     NOT NULL,  --basis_w?
          p_wert_abzu_brutto       	NUMERIC(16,4), --     NOT NULL, --damit sum usw nicht auf null triftt muß 0
          p_wert_abzu_brutto_gwaer 	NUMERIC(20,8), --     NOT NULL,--basis_w?
          p_wert_tot_brutto       	NUMERIC(16,4), --     NOT NULL, --damit sum usw nicht auf null triftt muß 0
          p_wert_tot_brutto_gwaer 	NUMERIC(20,8)  --     NOT NULL--basis_w?
         ) INHERITS (TSystem_Wawi.beleg_p__preise_waer);
         
        CREATE TABLE TSystem_Wawi.beleg_p__preise () INHERITS (TSystem_Wawi.beleg_p__preise_steu_brutto, TSystem_Wawi.beleg_p__preise_rabatt, TSystem_Wawi.beleg_p__preise_pe);
        CREATE TABLE TSystem_Wawi.beleg_p__extend__bstat (
          p_bstat1                          VARCHAR(3),         -- REFERNCES auftgbs,
          p_bstat2                          VARCHAR(3),
          p_bstat3                          VARCHAR(3)
         );
        CREATE TABLE TSystem_Wawi.beleg_p__extend__wawi__adk (
         p_ad_krz                 VARCHAR(21) REFERENCES adk ON UPDATE CASCADE,
         p_ad_krzl                VARCHAR(30) REFERENCES adressen_keys ON UPDATE CASCADE,
         p_ad_krzf                VARCHAR(30) REFERENCES adressen_keys ON UPDATE CASCADE
         );
        
        CREATE TABLE TSystem_Wawi.beleg_p__extend__wawi__datum__bedarf ( --Termine und Flag für Bedarfsberechnung
         p_datuml_wunsch          DATE,  
         p_datuml_bestaetigt      DATE,
         p_datuml_verschoben      DATE, 
         p_datuml_text            VARCHAR(100),
         p_datuml_auslieferterm   DATE,
         p_datuml_week            VARCHAR(7),
         p_nbedarf                BOOLEAN NOT NULL DEFAULT false --später mal in bedarfswirksam umbenennen und default true
         );
        
        
        
        CREATE TABLE TSystem_Wawi.beleg_p__extend__zuschnitte (
          zs_o6_dimi              VARCHAR(50),
          zs_o6_stkz              INTEGER,        -- Stück  Zuschnitt
          zs_o6_lz                NUMERIC(12,4),  -- Länge  Zuschnitt
          zs_o6_bz                NUMERIC(12,4),  -- Breite Zuschnitt
          zs_o6_hz                NUMERIC(12,4),  -- Höhe   Zuschnitt
          zs_o6_zz                NUMERIC(12,4),  -- Zugabe Zuschnitt
          zs_o6_zme               INTEGER REFERENCES mgcode, -- ZuschnittME
          zs_o6_pos               INTEGER        -- Pos Zuschnitt #10848
         );
        CREATE TABLE TSystem_Wawi.beleg_p__extend__adress_referenz (
          p_adress_referenz_nummer          VARCHAR(50),        -- (bda) Bestellnummer des Auftraggebers - Referenz-Auftragsnummer
          p_adress_referenz_pos             INTEGER,
          p_adress_referenz_erstellt_datum  DATE                -- Erstelldatum Referenz (Ihre Bestellung vom )
         );
        ----
        -- CREATE TABLE TSystem_Wawi.beleg_p__extend_adressreferenz ? artikelreferenz, bestellnummer referenz, bestelldat usw.    
        /* CREATE TABLE TSystem_Wawi.beleg_p__extend__wawi__dokunr ( --eine Position kann zusätzlich auf einem anderem Dokument liegen
         pdok_id                   SERIAL         PRIMARY KEY,
         pdok_k_id                 INTEGER        NOT NULL REFERENCES TSystem_Wawi.beleg_k, --das andere Dokument unter welchem die Position liegt
         pdok_p_id                 INTEGER        NOT NULL REFERENCES TSystem_Wawi.beleg_p
         );*/ -- z_dokunr?
        
        
        -- Klären: Ableiten (Mengen/Preise) > eher nicht, Artikelzuordnung usw. 
        CREATE TABLE TSystem_Wawi.Abzu_P (
          az_id                  SERIAL PRIMARY KEY, -- ID des Zuschlags
          az_id_oldstructure     INTEGER,
          az_type                VARCHAR(1) NOT NULL DEFAULT 'E', -- Zuschlagstyp, E-Einmalig, P-Position, M-Per ME
          az_pos                 INTEGER NOT NULL, -- Position
          az_abz_id              INTEGER REFERENCES public.abzu, -- ID der Vorgabe (public: doppelter Name für View)
          --az_parent_id        INTEGER, -- ID des Datensatzes an dem der Zuschlag hängt
          az_k_id                INTEGER NOT NULL REFERENCES TSystem_Wawi.beleg_k ON DELETE CASCADE, --kopfbezogen
          az_p_id                INTEGER REFERENCES TSystem_Wawi.beleg_p ON DELETE CASCADE, --positionsbezogen
         
          az_anzahl              NUMERIC(14,6), -- Anzahl / Menge
          az_preis               NUMERIC(12,4), -- Betrag in Währung des Parent-Datensatzes
          az_preis_prozentual    NUMERIC(6,2), -- Prozentualer Zuschlag auf Basis des Parent-Betrags
          
          az_done                BOOLEAN NOT NULL DEFAULT False,
          
          az_steu_code           INTEGER REFERENCES steutxt, -- Steuercode (meist gleich Parent)
          az_steu_proz           NUMERIC(6,2) NOT NULL DEFAULT 0, -- Prozentsatz der Steuer
        
          az_wert_netto          NUMERIC(16,4),
          az_wert_netto_gwaer    NUMERIC(20,8),
          az_wert_brutto         NUMERIC(16,4),
          az_wert_brutto_gwaer   NUMERIC(20,8),
          
          az_konto               VARCHAR(25),       -- Kontierung TODO references erloes?  
          az_canSkonto           BOOLEAN NOT NULL DEFAULT FALSE,
          
          az_visible             BOOLEAN, -- Auf Dokument sichtbar oder nicht?
          az_txt                 TEXT, -- Zusätzlicher Hinweistext
          az_txt_rtf             TEXT, -- Zusätzlicher Hinweistext (RTF)
          az_txt_int             TEXT, -- Interner zusatztext (erscheint nicht auf Dokumenten)
          
          az_tablename           VARCHAR(50),
          az_source_table        VARCHAR(30), -- Aus welcher Quelle wurde Abzu hierhin kopiert
          az_source_dbrid        VARCHAR(32), -- Aus welchem Datensatz wurde Abzu hierhin kopiert
          
          --
        
          dbrid                     VARCHAR(32) UNIQUE NOT NULL DEFAULT nextval('db_id_seq'),
          insert_date               DATE,
          insert_by                 VARCHAR(32),
          modified_date             TIMESTAMP(0),
          modified_by               VARCHAR(32)
          
          /*
          beaz_canSkonto         AS az_canSkonto      , -- Gilt Skonto für den Zuschlag?  
          */
         );
        
        -- Trigger AbzuDone
        --
    
    
        -- ################## [00] Warenwirtschaft-Grundtabellen: Trigger, Constraints TWAWI!!!!!
        
        CREATE TABLE twawi.beleg_k (
          kx_refbeleg               VARCHAR(75),
          k_spco                    INTEGER /*TODO NOT NULL*/ REFERENCES adkspco
          ) INHERITS (TSystem_Wawi.beleg_k, TSystem_Wawi.beleg_k__preise_steu_zahlung);
          
         
        CREATE TABLE twawi.beleg_p (
          p_ak_hest                         NUMERIC(12,4),      -- TODO klärung Trigger?
          p_ak_vkpbas                       NUMERIC(12,4),      -- TODO klärung Trigger?
          --
          px_an_nr                          VARCHAR(50),        -- REFERENCES anl, --ACHTUNG: Spaltenname auch in Verwendung wenn nicht hiervon abgeleitet
          --
          p_ks                              VARCHAR(9),         -- REFERENCES ksv,
          p_konto_erloes                    VARCHAR(10),        -- REFERENCES erloes,
          p_konto_aufwand                   VARCHAR(10),        -- REFERENCES erloes,
          --
          p_vtp_id                          INTEGER             -- TODO References vertrag_pos
          ) INHERITS (TSystem_Wawi.beleg_p, TSystem_Wawi.beleg_p__preise, TSystem_Wawi.beleg_p__extend__adress_referenz, TSystem_Wawi.beleg_p__extend__bstat);
         -- kein TSystem_Wawi.belegpos__art__wawi__mengen, > nur Grundfunktionen bis Preis, bei Rechnung
         
        CREATE TABLE twawi.abzu_p () INHERITS (TSystem_Wawi.abzu_p);
        -- Standard-Abzu Wawi Trigger: Übernahme abzuschläge, schliessen Vorgänger
         -- Quell-Zuschläge mit Typ 'E' werden erledigt gesetzt bei Übernahme aus Bestellung
         CREATE OR REPLACE FUNCTION TSystem_wawi.abzu_p__b_152_u__abzid() RETURNS TRIGGER AS $$
          BEGIN
           -- eigentlich aus Vorposition übernommener Abzuschlag wird einfach umgeschrieben (nicht gelöscht)
           new.az_source_table := NULL;
           new.az_source_dbrid := NULL;
           RETURN new;
          END $$ LANGUAGE plpgsql;
         --
         CREATE OR REPLACE FUNCTION TSystem_wawi.abzu_p__a_154_iud__srcabzu_done() RETURNS TRIGGER AS $$
          DECLARE _k_code VARCHAR;
                   --sum_anzahl RECORD;
          BEGIN  
           IF (TG_OP IN ('INSERT', 'UPDATE')) THEN
              --SELECT sum(az_anzahl) INTO sum_anzahl FROM TSystem_wawi.abzu_p WHERE az_source_dbrid = new.az_source_dbrid; -- Gesamtmenge übernommen
    
              SELECT k_code INTO _k_code FROM TSystem_Wawi.beleg_k WHERE k_id = new.az_k_id;
              -- 
              IF new.az_tablename = 'abzu_p__rechnungv' AND _k_code IN ('P', 'T', 'G') THEN -- Proforma, Abschlagsrechnung, Gutschrift: schliesst Abzuschlag nicht. Klärung: Gutschrift öffnet? Nur wenn Menge wieder offen sein soll
                 RETURN new;
               END IF;
              --
              IF tg_op = 'INSERT' THEN -- Abzu_Set_Done Todo: Klärung Typ Mengenbezogen und Mengenänderung
                 IF new.az_source_table IN ('auftgabzu', 'ldsabzu') THEN --Abzu_Set_Done
                    PERFORM TWawi.Abzu_Set_Done(new.az_source_table, new.az_source_dbrid, TRUE, TRUE); -- Default nur Einmalkosten (Parameter)
                  END IF;
                END IF; 
              --
              IF (TG_OP = 'UPDATE') THEN -- Änderung von az_abz_id
                 -- Pos. 1 war z.Bsp. Rüstkosten und wurde einfach per F2 auf Transport umgeschrieben
                 IF (old.az_abz_id IS DISTINCT FROM new.az_abz_id) AND (old.az_source_dbrid IS NOT NULL) THEN -- eigentlich aus Vorposition übernommener Abzuschlag wird einfach umgeschrieben (nicht gelöscht)
                     -- Beachte Before Trigger welcher   az_source_dbrid := NULL;  
                     -- Übernommen-Flag setzen mit Standardfunktion (Nur Einmalkosten)
                     IF old.az_source_table IN ('auftgabzu', 'ldsabzu') THEN --Abzu_Set_Done
                        PERFORM TWawi.Abzu_Set_Done(old.az_source_table, old.az_source_dbrid, FALSE, TRUE);
                      END IF;  
                     --
                     -- Sonderbehandlung
                      IF new.az_tablename = 'abzu_p__rechnungv' THEN
                         -- Rg.Nr. im Auftragszuschlag zurücksetzen wenn anderer Zuschlag ausgewählt (Unabhängig vom Zuschlagstyp)
                         UPDATE auftgabzu SET
                           az_bebnr = NULL
                         WHERE (old.az_source_dbrid = auftgabzu.dbrid) -- Rg.Zuschlag wurde aus diesem auftgabzu kopiert
                           AND (old.beaz_bebnr = az_bebnr)              -- Auftragszuschlag bisher ohne Belegnummer, da steht also immer nur die erste Belegnummer drin.
                           AND (old.az_abz_id = az_abz_id);            -- Es handelt sich tatsächlich um den gleichen Zuschlag (z.Bsp. Rüstkosten)
                       END IF;
                  END IF;
               END IF;          
              -- Sonderbehandlungen
               IF new.az_tablename = 'abzu_p__rechnungv' THEN -- Rg.Nr. im Auftragszuschlag setzen (Unabhängig vom Zuschlagstyp)
                 UPDATE auftgabzu SET
                   az_bebnr = p_k_nummer
                 FROM TSystem_Wawi.beleg_p                   
                 WHERE p_k_id = new.az_k_id
                   AND (new.az_source_dbrid = auftgabzu.dbrid) -- Rg.Zuschlag wurde aus diesem auftgabzu kopiert
                   AND (az_bebnr IS NULL )                       -- Auftragszuschlag bisher ohne Belegnummer, da steht also immer nur die erste Belegnummer drin.
                   AND (new.az_abz_id = az_abz_id);            -- Es handelt sich tatsächlich um den gleichen Zuschlag (z.Bsp. Rüstkosten)
                  --
                END IF;
           ELSE 
              -- TODO: Raise Notice beim wieder öffnen
              IF old.az_source_table IN ('auftgabzu', 'ldsabzu') THEN --Abzu_Set_Done
                 PERFORM TWawi.Abzu_Set_Done(old.az_source_table, old.az_source_dbrid, FALSE, TRUE); -- Default nur Einmalkosten (Parameter)
               END IF;  
              -- Sonderbehandlungen
               IF old.az_tablename = 'abzu_p__rechnungv' THEN -- Auftragsabzuschlag hat (alt) noch die Rechnungsnummer als Spalte für Übernommen
                 -- Rg.Nr. im Auftragszuschlag zurücksetzen  (Unabhängig vom Zuschlagstyp)
                 UPDATE auftgabzu SET
                   az_bebnr = NULL
                 FROM TSystem_Wawi.beleg_p
                 WHERE p_k_id = old.az_k_id
                   AND (old.az_source_dbrid = auftgabzu.dbrid) -- Rg.Zuschlag wurde aus diesem auftgabzu kopiert
                   AND (p_k_nummer = az_bebnr)               -- Im Auftragszuschlag stand bisher die Belegnummer
                   AND (old.az_abz_id = az_abz_id);            -- Es handelt sich tatsächlich um den gleichen Zuschlag (z.Bsp. Rüstkosten)
                 --
                END IF;
           END IF;   
           --
           RETURN new; 
          END $$ LANGUAGE plpgsql;
        -- Standard Trigger für Menge Übernommen >  AFTER TRIGGER MENGEN PROPAGATE Weitergabe von übernommenen Mengen > Rechnung > Lieferschein > Auftrag/Bestellun >> weiter unten
        
      
        -- ********************************************** TRIGGER UND FUNKTIONALITÄTEN **********************************************
        
        
        -- beleg_ X K P __b_00_i__tablename() --Eintragen der Source (auftg, ldsdok)
        
            CREATE FUNCTION TSystem_Wawi.beleg_k__b_000_i__tablename() RETURNS TRIGGER AS $$
               BEGIN
                new.k_tablename := REPLACE(tg_relname, 'beleg_k__', '');
                RETURN new;
               END $$ LANGUAGE plpgsql;
               
            CREATE FUNCTION TSystem_Wawi.beleg_p__b_000_i__tablename() RETURNS TRIGGER AS $$
               BEGIN
                new.p_tablename := REPLACE(tg_relname, 'beleg_p__', '');
                RETURN new;
               END $$ LANGUAGE plpgsql;
               
            CREATE FUNCTION TSystem_Wawi.beleg_p__trigger__tablename__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
              BEGIN
               EXECUTE $$          
                  CREATE TRIGGER b_000_i__tablename--Grundtrigger anhängen<
                    BEFORE INSERT
                    ON $$ || _schema_name || '.' || _table_name || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_000_i__tablename()
                    $$
               RETURN;
              END $f$ LANGUAGE plpgsql;            
              
            CREATE FUNCTION TSystem_Wawi.beleg_k__trigger__tablename__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
              BEGIN
               EXECUTE $$          
                  CREATE TRIGGER b_000_i__tablename--Grundtrigger anhängen<
                    BEFORE INSERT
                    ON $$ || _schema_name || '.' || _table_name || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_k__b_000_i__tablename()
                    $$
               RETURN;
              END $f$ LANGUAGE plpgsql;     
    
            --
            CREATE FUNCTION TSystem_Wawi.abzu_p__b_000_i__tablename() RETURNS TRIGGER AS $$
               BEGIN
                new.az_tablename := TG_RELNAME;
                RETURN new;
               END $$ LANGUAGE plpgsql;
        -- beleg_ X K P __b_00_i__tablename()
        
        -- ###############  Kopf ####################
        
        -- FUNCTION TSystem_Wawi.beleg_K TRIGGER -- Währung usw. Von Kopf > Position > Abzu??
        -- FUNCTION TRIGGER wert
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__a_310_u__propagate__abzu_p__steu_waer_rabatt() RETURNS TRIGGER AS $$      
              BEGIN
                UPDATE TWawi.beleg_p SET
                       -- Felder übertragen. Wenn diese aber angepasst - abweichend sind, dann beibehalten
                       p_waer           = IFTHEN(p_waer      = old.k_waer,      new.k_waer,      p_waer),
                       p_waer_kurs      = IFTHEN(p_waer_kurs = old.k_waer_kurs, new.k_waer_kurs, p_waer_kurs),
                       
                       p_steu_code      = IFTHEN(p_steu_code IS DISTINCT FROM old.k_steu_code, p_steu_code, new.k_steu_code),
                       p_steu_proz      = IFTHEN(p_steu_proz = old.k_steu_proz, new.k_steu_proz, p_steu_proz),
                       
                       p_rabatt_gesamt  = new.k_rabatt_gesamt, --Gesamtrabatt immer über alle gleich, daher kein IFTHEN. > Wiki
                       -- Werte in jedem Fall neu berechnen (k_rund_faktor gibts nicht in Pos)
                       p_wert_netto     = NULL
                 WHERE p_k_id     = new.k_id; --Positionszeilen neu berechnen
                --  
                UPDATE TWawi.abzu_p SET
                       -- Felder übertragen. Wenn diese aber angepasst - abweichend sind, dann beibehalten
                       az_steu_code     = IFTHEN(az_steu_code IS DISTINCT FROM old.k_steu_code, az_steu_code, new.k_steu_code),
                       az_steu_proz     = IFTHEN(az_steu_proz = old.k_steu_proz, new.k_steu_proz, az_steu_proz),
                       --               
                       az_wert_netto    = NULL 
                 WHERE az_k_id = new.k_id AND az_p_id IS NULL; -- Abzuschlag Kopfbezogen aktualisieren
                 -- abzuschläge Positionsbzeogen aktualisieren (Steuern)  anhand >>>   beleg_p__a_30_u__wert__propagate
                RETURN new;
              END $$ LANGUAGE plpgsql;           
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__b_390_iu__wert__tot__calculated() RETURNS TRIGGER AS $$
               BEGIN
                new.k_wert_netto                 := COALESCE(new.k_wert_netto, 0);
                new.k_wert_netto_gwaer           := COALESCE(new.k_wert_netto_gwaer, 0);
                new.k_wert_abzu_netto            := COALESCE(new.k_wert_abzu_netto, 0);
                new.k_wert_abzu_netto_gwaer      := COALESCE(new.k_wert_abzu_netto_gwaer, 0);
                new.k_wert_abzuk_netto           := COALESCE(new.k_wert_abzuk_netto, 0);
                new.k_wert_abzuk_netto_gwaer     := COALESCE(new.k_wert_abzuk_netto_gwaer, 0);
                new.k_wert_tot_netto             := new.k_wert_netto         + new.k_wert_abzu_netto        + new.k_wert_abzuk_netto;
                new.k_wert_tot_netto_gwaer       := new.k_wert_netto_gwaer   + new.k_wert_abzu_netto_gwaer  + new.k_wert_abzuk_netto_gwaer;
                --
                RETURN new;
               END $$ LANGUAGE plpgsql;
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__b_390_iu__wert__tot__brutto__calculated() RETURNS TRIGGER AS $$
               BEGIN
                new.k_wert_brutto                := COALESCE(new.k_wert_brutto, 0);
                new.k_wert_brutto_gwaer          := COALESCE(new.k_wert_brutto_gwaer, 0);             
                new.k_wert_abzu_brutto           := COALESCE(new.k_wert_abzu_brutto, 0);
                new.k_wert_abzu_brutto_gwaer     := COALESCE(new.k_wert_abzu_brutto_gwaer, 0);             
                new.k_wert_abzuk_brutto          := COALESCE(new.k_wert_abzuk_brutto, 0);
                new.k_wert_abzuk_brutto_gwaer    := COALESCE(new.k_wert_abzuk_brutto_gwaer, 0);
                new.k_wert_tot_brutto            := new.k_wert_brutto        + new.k_wert_abzu_brutto       + new.k_wert_abzuk_brutto;
                new.k_wert_tot_brutto_gwaer      := new.k_wert_brutto_gwaer  + new.k_wert_abzu_brutto_gwaer + new.k_wert_abzuk_brutto_gwaer;
                --
                RETURN new;
               END $$ LANGUAGE plpgsql;
           --
        
        -- FUNCTION TRIGGER defaults, texte, invalidmessages
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__a_100_u__k_nummer() RETURNS TRIGGER AS $$
            BEGIN
             UPDATE TSystem_Wawi.beleg_p SET p_k_nummer = new.k_nummer, p_k_code = new.k_code WHERE p_k_id = new.k_id;
             RETURN new;
            END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__b_050_i__defaults_texte() RETURNS TRIGGER AS $$ --
              DECLARE belegtypRec     RECORD;
                      flag            BOOLEAN;
                      krz             VARCHAR;
                      spco            VARCHAR;
                      ident_belarzu	  VARCHAR;
              BEGIN
               -- Belegart je nach relname; todo: automatisieren mit default flag an belegart
        
                  -- Eingangsrechnung
                  IF new.k_tablename = 'rechnunge' THEN
                    new.k_kba_key := COALESCE(new.k_kba_key, '1');
                  -- Lieferschein
                  ELSIF new.k_tablename = 'lieferscheinv' THEN
                    new.k_kba_key := COALESCE(new.k_kba_key, '3');
                  -- Lieferantenursprungserklärung
                  ELSIF (new.k_tablename = 'lieferantenursprungse') THEN
                    new.k_kba_key := COALESCE(new.k_kba_key, '5');
                  END IF;    
              
               -- Texte
                SELECT ad_krz INTO krz FROM adressen_view WHERE ad_krz = new.k_ad_krz;
                -- Sprachcode je nachdem ob Einkauf / Verkauf
                IF new.k_tablename IN ('lieferscheinv', 'rechnungv') THEN
                   spco := prodat_languages.adk1_spco(krz);
                 ELSE
                   spco := prodat_languages.adk2_spco(krz);
                 END IF;
                --
                -- Allgemeine und belegspezifische Vorgaben bei Neuanlage : ident_belarzu
                 IF new.k_tablename = 'lieferscheinv' THEN
                     IF new.k_kba_key = 6 THEN 
                            ident_belarzu := 'DOKLIEFSCHBEISTELL';  -- IF new.beld_belegart = 6 THEN -- Beistellieferschein
                      ELSE
                            ident_belarzu := 'DOKLIEFSCH';
                      END IF;
                     
                  END IF;
                 --
                 IF new.k_tablename = 'rechnungv' THEN ident_belarzu := 'DOKFAKT'; END IF;
                 --
                 IF new.k_tablename = 'lieferantenursprungse' THEN ident_belarzu := 'DOKLUE'; END IF;
                --
                -- Kopftext / Fußtext: Anhand von Text-Ident und Sprachcode, die Standardtexte zuweisen
                 IF new.k_txt_anschr IS NULL THEN -- kopf
                   SELECT txt, txtrtf INTO new.k_txt_anschr, new.k_txt_anschr_rtf FROM belarzu__zu_tit__gettxtrtf(ident_belarzu || '_TXT_KOPF', spco);
                 END IF;
                 
                 IF new.k_txt_schluss IS NULL THEN -- Fuss
                   SELECT txt, txtrtf INTO new.k_txt_schluss, new.k_txt_schluss_rtf FROM belarzu__zu_tit__gettxtrtf(ident_belarzu || '_TXT_FUSS', spco);
                 END IF;
               --
               RETURN new;
              END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__b_500_iu__pruef_freigabe1() RETURNS TRIGGER AS $$
            BEGIN
             new.k_pruef_db_usename1   := COALESCE(new.k_pruef_db_usename1, current_user);
             new.k_pruef_freigabe_datum1  := COALESCE(new.k_pruef_freigabe_datum1, current_date);
             --
             RETURN new;
            END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__a_700_iu__invalidmessages() RETURNS TRIGGER AS $$
            BEGIN
             IF (SELECT true FROM steutxt WHERE steu_z = new.k_steu_code AND steu_valid_to < current_date) THEN
                PERFORM PRODAT_TEXT(15810); --Steuer abgelaufen / Ungültig
             END IF;
             RETURN new;
            END $$ LANGUAGE plpgsql;
            --
        -- TRIGGER CREATE FUNCTION beleg_k  /  beleg_k__trigger__all__create
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__trigger__wert__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
              DECLARE
                -- for now a more simple fix
                tname text = _schema_name || '.' ||  _table_name;
              BEGIN       
                EXECUTE $$ --Grundtrigger Texte anhängen
                  CREATE TRIGGER b_050_i__defaults_texte 
                    BEFORE INSERT
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_k__b_050_i__defaults_texte();
                  $$;
                --
                IF tsystem.column_exists(_table_name, 'k_wert_netto', _schema_name ) THEN --
                   EXECUTE $$
                   CREATE TRIGGER b_390_iu__wert__tot__calculated 
                    BEFORE INSERT OR UPDATE --im Insert gibt es noch keine Positionen die zu aktualisieren wären, aber COALESCE
                    -- OF ? alle, eigentlich mal calculated
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_k__b_390_iu__wert__tot__calculated(); 
                   $$;
                 END IF;  
                IF tsystem.column_exists(_table_name, 'k_wert_brutto', _schema_name ) THEN --
                   EXECUTE $$
                   CREATE TRIGGER b_390_iu__wert__tot__brutto__calculated 
                    BEFORE INSERT OR UPDATE --im Insert gibt es noch keine Positionen die zu aktualisieren wären, aber COALESCE
                    -- OF ? alle, eigentlich mal calculated
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_k__b_390_iu__wert__tot__brutto__calculated(); 
                   $$;
                 END IF; 
                --
                IF tsystem.column_exists(_table_name, 'k_steu_code', _schema_name ) THEN --
                   EXECUTE $$
                   CREATE TRIGGER a_310_u__propagate__abzu_p__steu_waer_rabatt
                    AFTER UPDATE --im Insert gibt es noch keine Positionen die zu aktualisieren wären
                    OF  k_steu_code, k_steu_proz
                      , k_waer, k_waer_kurs
                      , k_rund_faktor, k_rabatt_gesamt
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_k__a_310_u__propagate__abzu_p__steu_waer_rabatt();
    
                   CREATE TRIGGER a_700_iu__invalidmessages
                    AFTER INSERT OR UPDATE
                    OF k_steu_code
                    ON $$ || tname || $$
                    FOR EACH ROW
                    WHEN (new.k_steu_code IS NOT NULL)
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_k__a_700_iu__invalidmessages();            
                    $$;
                 END IF;
                --
                IF tsystem.column_exists(_table_name, 'k_pruef_freigabe1', _schema_name ) THEN --
                   EXECUTE $$
                   CREATE TRIGGER b_500_iu__pruef_freigabe 
                    BEFORE INSERT OR UPDATE --im Insert gibt es noch keine Positionen die zu aktualisieren wären, aber COALESCE
                    OF k_pruef_freigabe1
                    ON $$ || tname || $$
                    FOR EACH ROW
                    WHEN (new.k_pruef_freigabe1) 
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_k__b_500_iu__pruef_freigabe1(); 
                   $$;
                 END IF;
                --
               RETURN;
              END $f$ LANGUAGE plpgsql;  
        
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_k__trigger__all__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
             BEGIN
              PERFORM TSystem_Wawi.beleg_k__trigger__tablename__create( _schema_name, _table_name );
              --
              IF tsystem.column_exists( _table_name, 'k_wert_netto', _schema_name ) THEN --
                 PERFORM TSystem_Wawi.beleg_k__trigger__wert__create( _schema_name, _table_name );
              END IF;
              --
               EXECUTE $$
                  CREATE TRIGGER a_100_u__k_nummer
                    AFTER UPDATE
                    OF k_nummer, k_code
                    ON $$ || _schema_name || '.' || _table_name || $$ 
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_k__a_100_u__k_nummer();
                    $$;
              --
              RETURN;
             END $f$ LANGUAGE plpgsql;   
        -- CONSTRAINTS beleg_k : Foreign Key usw.
        
           CREATE FUNCTION TSystem_Wawi.beleg_k__constraints__all__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
             BEGIN
              EXECUTE $$ ALTER TABLE $$ || _schema_name || '.' || _table_name || $$ ADD CONSTRAINT $$ || _table_name || '__pkey'               || $$ PRIMARY KEY (k_id) $$;
              
              EXECUTE $$ ALTER TABLE $$ || _schema_name || '.' || _table_name || $$ ADD CONSTRAINT $$ || _table_name || '__k_nummer_key'       || $$ UNIQUE(k_nummer, k_code, k_tablename) $$;
              EXECUTE $$ ALTER TABLE $$ || _schema_name || '.' || _table_name || $$ ADD CONSTRAINT $$ || _table_name || '__dbrid_key'          || $$ UNIQUE(dbrid) $$;
              
              EXECUTE $$ ALTER TABLE $$ || _schema_name || '.' || _table_name || $$ ADD CONSTRAINT $$ || _table_name || '__k_ad_krz_fkey'      || $$ FOREIGN KEY (k_ad_krz)               REFERENCES adressen_keys ON UPDATE CASCADE $$;
              EXECUTE $$ ALTER TABLE $$ || _schema_name || '.' || _table_name || $$ ADD CONSTRAINT $$ || _table_name || '__k_kba_fkey'         || $$ FOREIGN KEY (k_tablename, k_kba_key) REFERENCES TSystem_Wawi.beleg_k__belart (kba_tablename, kba_key) ON UPDATE CASCADE $$;
              
              EXECUTE $$ CREATE INDEX $$ || _table_name || '__k_id_oldstructure' || $$ ON $$ || _schema_name || '.' || _table_name || $$ (k_id_oldstructure) WHERE k_id_oldstructure IS NOT NULL $$;
                        
              EXECUTE FORMAT('CREATE TRIGGER %I BEFORE INSERT OR UPDATE ON %I.%I FOR EACH ROW EXECUTE PROCEDURE table_modified();', _table_name || '_set_modified', _schema_name, _table_name);
              EXECUTE FORMAT('CREATE TRIGGER %I AFTER DELETE ON %I.%I FOR EACH ROW EXECUTE PROCEDURE table_delete();', _table_name || '_table_detele', _schema_name, _table_name);      
              --
              IF tsystem.column_exists(_table_name, 'k_steu_code', _schema_name) THEN --indicator INHERITS beleg_k__preise_steu_zahlung
                 EXECUTE $$ ALTER TABLE $$ || _schema_name || '.' || _table_name || $$ ADD CONSTRAINT $$ || _table_name || '__k_steu_code_fkey'   || $$ FOREIGN KEY (k_steu_code)    REFERENCES steutxt $$;
              END IF;
              IF tsystem.column_exists(_table_name, 'k_waer', _schema_name) THEN --indicator INHERITS beleg_k__preise_steu_zahlung
                 EXECUTE $$ ALTER TABLE $$ || _schema_name || '.' || _table_name || $$ ADD CONSTRAINT $$ || _table_name || '__k_waer_fkey'        || $$ FOREIGN KEY (k_waer)         REFERENCES bewa ON UPDATE CASCADE $$;
              END IF;
              --
              RETURN;
             END $f$ LANGUAGE plpgsql; 
        --
        
        -- ###############  Position #################
        
        -- Notwendige Grundfunktionen (next pos)
         CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__nextpos(in_k_id INTEGER, stepwidth INTEGER DEFAULT NULL) RETURNS INTEGER AS $$
          SELECT COALESCE( (SELECT max(p_pos) FROM TSystem_Wawi.beleg_p WHERE p_k_id = in_k_id) + COALESCE(stepwidth, 1), COALESCE(stepwidth, 1))
          $$ LANGUAGE SQL;
        --
        
        -- FUNCTION beleg_p für p_b_nummer,   -- für KOMPATIBILITÄT: holt sich selbstständig anhand der nummer die Verknüpfung (p_k_id) (Speziell: Foreign Key bz_be_bnr)
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_011_iu__p_nummer() RETURNS TRIGGER AS $$
              BEGIN
               --
               IF new.p_k_id IS NULL AND new.p_k_nummer IS NOT NULL THEN
                  new.p_k_id := k_id FROM TSystem_Wawi.beleg_k WHERE k_nummer = new.p_k_nummer AND k_code IS NOT DISTINCT FROM new.p_k_code; /*TODO AND tablename*/ --??
                  -- new.p_b_nummer := NULL;-- eigentlioch nicht möglich, siehe ag_nr
               END IF;
               --
               -- Wenn hier noch kein Kopf da ist, muß einer angelegt werden im Fall es sind Adressdaten in Position vorhanden.
               -- Todo: prüfen auf richtig Tabelle und oder Ableitung, damit es nicht knallt
               IF new.p_k_id IS NULL THEN
                  INSERT INTO TSystem_Wawi.beleg_k(k_code, k_nummer, k_ad_krz) VALUES (new.p_k_code, new.p_k_nummer, new.p_ad_krz) RETURNING k_id INTO new.p_k_id;          
               END IF;
               --
               IF new.p_k_nummer IS NULL THEN -- Kopfnummer ist immer gefüllt, Code wird syncron gehalten
                  SELECT k_nummer, k_code INTO new.p_k_nummer, new.p_k_code FROM TSystem_Wawi.beleg_k WHERE k_id = new.p_k_id;
                END IF;
               --
               RETURN new;
              END $$ LANGUAGE plpgsql;   
        -- TRIGGER CREATE FUNCTION TSystem_Wawi.beleg_p__b_011_iu__p_nummer__trigger__create
           CREATE FUNCTION TSystem_Wawi.beleg_p__trigger__p_nummer__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
              BEGIN
               EXECUTE $$
                  CREATE TRIGGER b_011_iu__p_nummer
                    BEFORE INSERT OR UPDATE
                    OF p_k_id, p_k_nummer
                    ON $$ || _schema_name || '.' || _table_name || $$ 
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_011_iu__p_nummer();
                    $$
               RETURN;
              END $f$ LANGUAGE plpgsql;       
        --
        
        -- FUNCTION BEFORE TRIGGER TSystem_Wawi.beleg_p defaults
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_052_i__defaults__p_pos() RETURNS TRIGGER AS $$ --
              BEGIN
                IF new.p_pos IS NULL THEN
                    new.p_pos := TSystem_Wawi.beleg_p__nextpos(new.p_k_id);
                 END IF;
                --
               RETURN new;
              END $$ LANGUAGE plpgsql;  
           --  
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_054_i__defaults__k_rabatt() RETURNS TRIGGER AS $$ --
              DECLARE r_beleg_k RECORD;
              BEGIN      
                SELECT k_rabatt_gesamt INTO r_beleg_k FROM TWawi.beleg_k WHERE k_id = new.p_k_id;
                --
                new.p_rabatt_gesamt :=  r_beleg_k.k_rabatt_gesamt;            
               RETURN new;
              END $$ LANGUAGE plpgsql;  
           --   
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_056_i__defaults__k_waer() RETURNS TRIGGER AS $$ --
              DECLARE r_beleg_k RECORD;
              BEGIN      
                SELECT k_waer, k_waer_kurs INTO r_beleg_k FROM TWawi.beleg_k WHERE k_id = new.p_k_id;
                --
                new.p_waer          :=  COALESCE(new.p_waer, r_beleg_k.k_waer);
                new.p_waer_kurs     :=  COALESCE(NULLIF(new.p_waer_kurs, 1), r_beleg_k.k_waer_kurs); --NULLIF wegen DEFAULT 1
                --
                IF NULLIF(new.p_waer_kurs, 0) IS NULL AND new.p_waer IS NOT NULL THEN
                   new.p_waer_kurs := waerkurs(new.p_waer);
                END IF;
               RETURN new;
              END $$ LANGUAGE plpgsql;  
           --  
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_058_i__defaults__k_steu() RETURNS TRIGGER AS $$ --
              DECLARE r_beleg_k RECORD;
              BEGIN      
                SELECT k_steu_code, k_steu_proz INTO r_beleg_k FROM TWawi.beleg_k WHERE k_id = new.p_k_id;
                --
                new.p_steu_code     :=  COALESCE(new.p_steu_code, r_beleg_k.k_steu_code);
                -- Wenn Steuercode = Kopf, dann auch Prozente vom Kopf
                IF new.p_steu_code   =  r_beleg_k.k_steu_code THEN
                   new.p_steu_proz  :=  r_beleg_k.k_steu_proz;
                END IF;
               RETURN new;
              END $$ LANGUAGE plpgsql;  
        -- TRIGGER CREATE FUNCTION defaults  
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__trigger__defaults__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
              DECLARE
                -- for now a more simple fix
                tname text = _schema_name || '.' ||  _table_name;
              BEGIN
               EXECUTE $$
                  CREATE TRIGGER b_052_i__defaults --Grundtrigger anhängen
                    BEFORE INSERT
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_052_i__defaults__p_pos();
                    $$;
               --
               IF tsystem.column_exists(_table_name, 'p_rabatt', _schema_name ) THEN
                  EXECUTE $$
                  CREATE TRIGGER b_054_i__defaults__k_rabatt 
                    BEFORE INSERT
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_054_i__defaults__k_rabatt();
                    $$;
                END IF;
               IF tsystem.column_exists(_table_name, 'p_waer', _schema_name ) THEN
                  EXECUTE $$
                  CREATE TRIGGER b_056_i__defaults__k_waer
                    BEFORE INSERT
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_056_i__defaults__k_waer();
                    $$;
                END IF;           
               IF tsystem.column_exists(_table_name, 'p_steu_code', _schema_name ) THEN
                  EXECUTE $$
                  CREATE TRIGGER b_058_i__defaults__k_steu
                    BEFORE INSERT
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_058_i__defaults__k_steu();
                    $$;
                END IF;            
               RETURN;
              END $f$ LANGUAGE plpgsql;
        --
        -- FUNCTION BEFORE TRIGGER beleg_p__b_150_iu__aknr ... frei; werte propagate > kopf & abzu proz
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_153_iu__aknr_frei() RETURNS TRIGGER AS $$
              DECLARE realaknr BOOL := False;
              BEGIN
                -- Checken, ob es eine richtige Artikelnummerneingabe gab. Wenn, dann übernehmen damit gleich und raus hier             
                 IF tg_op = 'INSERT' AND new.p_aknr IS NOT NULL THEN -- es gibt zwar die freie Artikelnummer, aber es wurde direkt die richtige Artikelnummer eingetragen
                       realaknr := TRUE;
                  END IF;
                 IF tg_op = 'UPDATE' THEN
                    IF new.p_aknr IS DISTINCT FROM old.p_aknr THEN
                       realaknr := TRUE;
                     END IF;
                  END IF;
                 --
                 IF realaknr THEN
                    new.p_aknr_frei := new.p_aknr;
                    RETURN new;
                  END IF;
                --
                IF EXISTS(SELECT true FROM art WHERE ak_nr = new.p_aknr_frei) THEN
                   new.p_aknr := new.p_aknr_frei;
                 ELSE
                   new.p_aknr := NULL;
                 END IF;
                --
                RETURN new; 
              END $$ LANGUAGE plpgsql;
           --   
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_155_iu__aknr() RETURNS TRIGGER AS $$
              BEGIN
                -- eigentlich muss im TRIGGER WHEN not null damit das Constraint kommt, dann ist das hier unnötig
                
                IF new.p_aknr IS NULL THEN -- Keine Artikelnummer > keine ME (freie Belegzeile)
                   new.p_me := NULL;
                 END IF;
                --
                IF new.p_me IS NULL AND new.p_aknr IS NOT NULL THEN --Standard ME für Artikel
                    new.p_me := tartikel.me__art__artmgc__m_id__by__ak_standard_mgc(new.p_aknr);
                 END IF;
                --
                IF tg_op = 'UPDATE' THEN -- Änderung der Artikelnummer : ME, PME mitnehmen!
                   IF  (old.p_aknr IS DISTINCT FROM new.p_aknr) THEN
                        IF (old.p_me IS NOT DISTINCT FROM new.p_me) THEN -- wenn p_aknr haben wir immer Mengeneinheit
                            new.p_me := tartikel.me__convertme_for_art__by__mid(new.p_aknr, old.p_me, True); -- Veruschen ME mitzunehmen, wenn nicht existent in neuem Artikel > StandardME ??? > Bei Stück?!, UF1 ?!
                        END IF;             
                    END IF;
                 END IF;
                -- Der Datensatz wurde mit einer für den Artikel ungültigen Mengeneinheit gespeichert. Tabelle: %, ID: %, Feld: %, ART-Nr.: %, Artmgc-ID: %
                 -- Mengeneinheit
                  IF new.p_aknr IS NOT NULL THEN
                     IF NOT TArtikel.me__art__artmgc__m_ids__valid(new.p_aknr, new.p_me) THEN
                         RAISE EXCEPTION     '%', Format(lang_text(13795), 'beleg_p', new.p_id::VARCHAR, 'p_me'    , new.p_aknr, new.p_me::VARCHAR);
                     END IF;
                   END IF; 
                --
                RETURN new; 
              END $$ LANGUAGE plpgsql;
    
           -- FUNCTION beleg_p__b__iu__menge_wert__gme(), POSSUM -- Grundtrigger für Folgetabellen
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_220_iu__menge__uf() RETURNS TRIGGER AS $$ --
              BEGIN
                IF new.p_me IS NOT NULL THEN -- Ohne Artikel mit freier Mengeneinheit (Freie Belegzeile)> immer UF1
                   new.p_menge_gme        := COALESCE(tartikel.me__menge__in__menge_uf1(new.p_me, new.p_menge), new.p_menge);
                 ELSE
                   new.p_menge_gme        := new.p_menge; -- ohne Mengeneinheit keine Umrechnung > Faktor fix 1
                 END IF;
                --
                -- Sonderbehandlungen
                --
                IF new.p_tablename = 'lieferscheinv' THEN
                   new.plv_mengef_gme := COALESCE(new.plv_mengef_gme, 0); -- Menge fakturiert default 0
                 END IF;
                --
                RETURN new;
              END $$ LANGUAGE plpgsql;  
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_320_iu__wert__pe_gme__calculate() RETURNS TRIGGER AS $$ -- Preis und Preiseinheit
             BEGIN
                -- Umrechnen der Preis-Mengeneinheit (Preis pro 1000 Stück)
                -- Wenn Nutzer Preis in Preiseinheit "p_preis_in_pe" angegeben hat, dann p_preis ausrechnen
                 IF TG_OP = 'INSERT' THEN
                     IF new.p_preis_pe IS NULL THEN
                         new.p_preis_pe := 1; -- Rechnung aus freiem Lagerabgang : kein Vorgängerbeleg aus dem das übernommen werden könnte
                      END IF;
                     --             
                     IF new.p_preis_in_pe IS NULL AND new.p_preis IS NOT NULL THEN -- kein Eingebener Preis in Preiseinheit vorhanden
                         new.p_preis_in_pe  := new.p_preis * new.p_preis_pe;
                      ELSE -- p_preis_in_pe angegeben oder alles ist 0
                         new.p_preis        := new.p_preis_in_pe / Do1If0(new.p_preis_pe);
                      END IF;
                  END IF;
                 --
                 IF TG_OP = 'UPDATE' THEN
                    -- Preis / PE geändert -> VKP Updaten
                    IF ((new.p_preis_in_pe IS DISTINCT FROM old.p_preis_in_pe) OR (new.p_preis_pe IS DISTINCT FROM old.p_preis_pe)) THEN
                        new.p_preis        := new.p_preis_in_pe / Do1If0(new.p_preis_pe);
                     ELSIF new.p_preis <> old.p_preis THEN -- VKP geändert und Preis / PE gleich -> Preis zurückrechnen.
                        new.p_preis_in_pe  := new.p_preis * new.p_preis_pe;
                     END IF;
                 END IF;
                -- Preis ist in abweichender Mengeneinheit (100 Stück a 5€ / 20 kg) 
                IF new.p_preis_me IS NOT NULL AND new.p_aknr IS NOT NULL THEN --me__art__artmgc__m_ids__valid
                    IF tg_op = 'UPDATE' THEN -- Änderung der Artikelnummer : ME, PME mitnehmen!
                       IF  (old.p_aknr IS DISTINCT FROM new.p_aknr) THEN
                            IF new.p_preis_me IS NOT NULL AND (old.p_preis_me IS NOT DISTINCT FROM new.p_preis_me) THEN 
                                new.p_preis_me := tartikel.me__convertme_for_art__by__mid(new.p_aknr, old.p_preis_me, True); -- Veruschen ME mitzunehmen, wenn nicht existent in neuem Artikel > StandardME ???
                            END IF;                
                        END IF;
                     END IF;
                    -- 
                    IF new.p_preis_me IS NOT NULL AND new.p_aknr IS NOT NULL THEN --me__art__artmgc__m_ids__valid
                         IF NOT TArtikel.me__art__artmgc__m_ids__valid(new.p_aknr, new.p_preis_me) THEN
                             RAISE EXCEPTION '%', Format(lang_text(13795), 'beleg_p', new.p_id::VARCHAR, 'p_preis_me', new.p_aknr, new.p_preis_me::VARCHAR);
                         END IF;
                     END IF;             
                    -- Preis in anderer Preiseinheit, als Menge.
                     -- Wir haben Basis = 1 Stk = 0,2 kg.
                     -- Verkauf 0,2 kg = 1 Stk a 5 € / Stk. Der Preis muß also zuerst zurück in kg gerechnet werden. 
                    new.p_preis             := COALESCE(tartikel.me__x__m_uf__div(new.p_me, new.p_preis), new.p_preis); -- Preismengeneinheit
                 END IF;            
                --
                new.p_preis_gme             := tartikel.me__preis__in__preis_uf1(new.p_me, new.p_preis); -- #7326 -- Beachte: Preismengeneinheit drüber
                --  Gibt es keine Währung, sind diese Felder immer gleich      
                new.p_preis_gwaer           := new.p_preis;
                new.p_preis_gme_gwaer       := new.p_preis_gme;              
              RETURN new;
             END $$ LANGUAGE plpgsql;
             
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_340_iu__wert__base__calculate() RETURNS TRIGGER AS $$ -- Preis * Menge
              BEGIN
                new.p_wert_netto             := new.p_menge              * new.p_preis; 
                --       
                new.p_wert_netto             := COALESCE(new.p_wert_netto, 0);
                new.p_wert_abzu_netto        := COALESCE(new.p_wert_abzu_netto, 0);
                --
                new.p_wert_tot_netto         := new.p_wert_netto         + new.p_wert_abzu_netto; -- Achtung, wegen Rabatt auch in rabatt__calculate
                -- Gibt es keine Währung, sind diese Felder immer gleich
                new.p_wert_netto_gwaer       := new.p_wert_netto; 
                new.p_wert_abzu_netto_gwaer  := new.p_wert_abzu_netto;             
                new.p_wert_tot_netto_gwaer   := new.p_wert_tot_netto;
                RETURN new; 
              END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_350_iu__wert__rabatt__calulate() RETURNS TRIGGER AS $$
              DECLARE faktor     NUMERIC; --Rabatte usw
              BEGIN
                -- Position ist Rabattfähig? => Faktor ermitteln aus Positions- und Gesamtrabatt
                IF new.p_preis_sumsubpos AND NOT new.p_rabatt_able THEN RAISE EXCEPTION 'preis_sumsubpos__rabatt_able'; END IF; -- Hauptpositionen sind immer Rabattfähig (widersprüche die sonst exakt aufgelöst werden müßten in Rabattberechnung)
                IF new.p_rabatt_able THEN
                    -- Hinweis: Gesamtrabatt bei Dokumentstruktur muß entsprechend vorher im Trigger dort geholt werden. Siehe 
                    faktor   := ( 1- (new.p_rabatt / 100)) * ( 1 - COALESCE( new.p_rabatt_gesamt , 0 ) / 100 );
                 ELSE
                    --Artikel kann keinen Rabatt erhalten
                    faktor   := 1;
                    -- new.p_rabatt := 0; --Klärung wirklich löschen? Weil : dann muß Löschen zurücksetzen auch die Werte neu setzen
                    -- new.p_rabatt_gesamt := 0;
                 END IF;
                --
                new.p_preis_rabattiert      := new.p_preis              * faktor;
                new.p_wert_netto            := new.p_menge              * new.p_preis_rabattiert;
                --       
                new.p_wert_netto            := COALESCE(new.p_wert_netto, 0);
                new.p_wert_tot_netto        := new.p_wert_netto         + new.p_wert_abzu_netto; -- Achtung, OHNE Rabatt auch in base__calculate
                --
                RETURN new;
              END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_360_iu__wert__gwaer__calulate() RETURNS TRIGGER AS $$
              BEGIN                                        
                new.p_preis_gwaer           := new.p_preis              * new.p_waer_kurs;
                new.p_preis_gme_gwaer       := new.p_preis_gme          * new.p_waer_kurs;
                --
                new.p_wert_netto_gwaer      := new.p_wert_netto         * new.p_waer_kurs;
                new.p_wert_abzu_netto_gwaer := new.p_wert_abzu_netto    * new.p_waer_kurs;
                new.p_wert_tot_netto_gwaer  := new.p_wert_tot_netto     * new.p_waer_kurs;       
                --        
               RETURN new;
              END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_370_iu__wert__steu_brutto__calculate() RETURNS TRIGGER AS $$ --beachte ldsdok__b_05_iu__stkvkpuf1 -- ACHTUNG Vererbung vererbt keine Trigger
              DECLARE _r_beleg_k RECORD;
                      rec        RECORD;
              BEGIN
                --
                SELECT k_rund_faktor INTO _r_beleg_k FROM TWawi.beleg_k WHERE k_id = new.p_k_id;       
                --
                new.p_wert_brutto         := new.p_wert_netto           * (1 + COALESCE(new.p_steu_proz, 0) / 100); --TODO Fail. Einfach Abzuschläge mit falschem Steuersatz verrechnet az_wert_brutto?
                new.p_wert_brutto_gwaer   := new.p_wert_netto_gwaer     * (1 + COALESCE(new.p_steu_proz, 0) / 100);
                -- Falls es keine Abzuschläge gibt, muß hier 0 stehen. Evtl mal weglassen, dann aber überall mit COALESCE oder NULLIF arbeiten!
                new.p_wert_abzu_brutto       := COALESCE(new.p_wert_abzu_brutto, 0);
                new.p_wert_abzu_brutto_gwaer := COALESCE(new.p_wert_abzu_brutto_gwaer, 0);
                -- Runden
                 IF true /*TSystem.Settings__GetBool('beleg_p__rund_faktor')*/ THEN        
                    IF 0.05 = _r_beleg_k.k_rund_faktor THEN
                        new.p_wert_netto := ROUND(ROUND(new.p_wert_netto * 20) / 20, 2);
                        new.p_wert_netto_gwaer := ROUND(ROUND(new.p_wert_netto_gwaer * 20) / 20, 2);
                        new.p_wert_netto := ROUND(ROUND(new.p_wert_netto * 20) / 20, 2);
                        new.p_wert_netto_gwaer := ROUND(ROUND(new.p_wert_netto_gwaer * 20) / 20, 2);
                    END IF;
                    IF 0.01 = _r_beleg_k.k_rund_faktor THEN
                        new.p_wert_netto := ROUND(new.p_wert_netto, 2);
                        new.p_wert_brutto_gwaer := ROUND(new.p_wert_netto_gwaer, 2);
                        new.p_wert_netto := ROUND(new.p_wert_netto, 2);
                        new.p_wert_brutto_gwaer := ROUND(new.p_wert_netto_gwaer, 2);
                    END IF;
                 END IF;
                --
                new.p_wert_tot_brutto        := new.p_wert_brutto        + new.p_wert_abzu_brutto;
                new.p_wert_tot_brutto_gwaer  := new.p_wert_brutto_gwaer  + new.p_wert_abzu_brutto_gwaer;
                --
                RETURN new;
              END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION tcache.beleg_p__cache_reset__iu() RETURNS TRIGGER AS $$
              BEGIN
                --
                PERFORM tcache.function_cache_setdirty_1param('beleg_p__pos_wert_calc', new.p_id);
                -- Kompatibilität: alte Caches auch Dirty, da alte Funktionen teilweise auch den Cache nutzen und dieser ja sonst niemals zurückgesetzt werden würde
                -- PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', new.p_id);         
                --
                RETURN new;
              END $$ LANGUAGE plpgsql;
           -- CREATE OR REPLACE FUNCTION beleg_p__a_390_iud__wert__propagate__beleg_k
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__function__create__propagate__beleg_k(in_brutto BOOLEAN = False) RETURNS VOID AS $f$ -- CI TAG: beleg_p wert propagate beleg_k
            DECLARE sql_select_brutto VARCHAR;
                    sql_tablep  VARCHAR;
                    sql_tablek  VARCHAR;
                    sql_update_brutto VARCHAR;
            BEGIN
             sql_select_brutto := ''; sql_update_brutto := ''; sql_tablep := 'TSystem_Wawi.beleg_p__preise_base'; sql_tablek := 'TSystem_Wawi.beleg_k__preise';
             --
             IF in_brutto THEN -- zusatz-sql für steuer updates
                sql_tablep        := 'TSystem_Wawi.beleg_p__preise_steu_brutto';
                sql_tablek        := 'TSystem_Wawi.beleg_k__preise_steu_zahlung';
                sql_select_brutto := 
                          $s$
                          ,SUM(COALESCE(p_wert_brutto, 0)) AS p_wert_brutto,
                          SUM(COALESCE(p_wert_brutto_gwaer, 0)) AS p_wert_brutto_gwaer,
                          SUM(COALESCE(p_wert_abzu_brutto, 0)) AS p_wert_abzu_brutto,
                          SUM(COALESCE(p_wert_abzu_brutto_gwaer, 0)) AS p_wert_abzu_brutto_gwaer
                          $s$;
                sql_update_brutto := 
                          $s$
                          ,k_wert_brutto           = r.p_wert_brutto,
                          k_wert_brutto_gwaer      = r.p_wert_brutto_gwaer,
                          k_wert_abzu_brutto       = r.p_wert_abzu_brutto,
                          k_wert_abzu_brutto_gwaer = r.p_wert_abzu_brutto_gwaer
                          $s$;
              END IF;
             -- Funktion zum Aktualisieren der Belegköpfe anlegen. Dazu in Abhängigkeit der Felder die Funktion generieren
             EXECUTE $$ CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_390_iud__wert__propagate__beleg_k$$|| IFTHEN(in_brutto, '__brutto', '__netto') ||$$() RETURNS TRIGGER AS $cf$
                              DECLARE r RECORD;
                                      my_k_id INTEGER;
                              BEGIN
                               IF tg_op = 'DELETE' THEN --my_k_id := new/old.p_k_id 
                                  my_k_id := old.p_k_id;
                                ELSE
                                  my_k_id := new.p_k_id;
                                END IF;
                               --
                               SELECT SUM(COALESCE(p_wert_netto ,0)) AS p_wert_netto, 
                                      SUM(COALESCE(p_wert_netto_gwaer, 0)) AS p_wert_netto_gwaer,
                                      SUM(COALESCE(p_wert_abzu_netto ,0)) AS p_wert_abzu_netto, 
                                      SUM(COALESCE(p_wert_abzu_netto_gwaer, 0)) AS p_wert_abzu_netto_gwaer
                                      --
                                      $$ || sql_select_brutto || $$
                                      --
                                      INTO r FROM $$ || sql_tablep || $$ p1 WHERE p_k_id = my_k_id AND 
                                                                                                (NOT p_preis_sumsubpos --nur werthaltige Unterpositionen 
                                                                                                OR
                                                                                                 -- Oder TotalUnterposition / SumSubPos hat noch keine Unterpositionen, dann diese nehmen
                                                                                                (p_preis_sumsubpos AND NOT EXISTS(SELECT true FROM $$ || sql_tablep || $$ p2 WHERE p2.p_parent_p_id = p1.p_id))
                                                                                                );       
                               --
                               UPDATE $$ || sql_tablek || $$ SET 
                                      k_wert_netto             = r.p_wert_netto,
                                      k_wert_netto_gwaer       = r.p_wert_netto_gwaer,
                                      k_wert_abzu_netto        = r.p_wert_abzu_netto,
                                      k_wert_abzu_netto_gwaer  = r.p_wert_abzu_netto_gwaer
                                      --
                                      $$ || sql_update_brutto || $$
                                      --
                                      WHERE k_id = my_k_id;
                               --
                               RETURN new;
                              END $cf$ LANGUAGE plpgsql;
                  $$;
               RETURN;
              END $f$ LANGUAGE plpgsql;
           --
           SELECT TSystem_Wawi.beleg_p__function__create__propagate__beleg_k();
           SELECT TSystem_Wawi.beleg_p__function__create__propagate__beleg_k(True); --Funktion für Brutto
           -- hier sind jetzt (nach 390) die Kopfwerte verfügbar zur Prozentualen Abzuschlagsberechnung kopfbezogen
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_400_iu__wert__propagate__abzu_p() RETURNS TRIGGER AS $$ --Steuern, Preisänderungen. Abzuschläge gibts nur wenn es auch Steuern gibt
              BEGIN
                UPDATE TWawi.abzu_p SET -- Prozentualer Abzuschlag am Kopf wird durch Position beeinflusst
                       az_wert_netto = NULL 
                       WHERE az_k_id = new.p_k_id AND az_p_id IS NULL AND az_preis_prozentual IS NOT NULL; --Positionszeilen neu berechnen
                --
                IF tg_op = 'UPDATE' THEN -- Positions - Abzuschläge kann es erst geben, wenn die Position bereits angelegt ist und damit nicht im Insert-Case
                    UPDATE TWawi.abzu_p SET -- Positionsabzuschläge: Steuern und Prozentual verhalten sich gleich
                       -- Felder übertragen. Wenn diese aber angepasst - abweichend sind, dann beibehalten
                       az_steu_code  = IFTHEN(az_steu_code IS DISTINCT FROM old.p_steu_code, az_steu_code, new.p_steu_code),
                       az_steu_proz  = IFTHEN(az_steu_proz = old.p_steu_proz, new.p_steu_proz, az_steu_proz),
                       --
                       az_wert_netto = NULL 
                       WHERE az_p_id = new.p_id; --Positionszeilen neu berechnen
                 END IF;
                --
                RETURN new;
              END $$ LANGUAGE plpgsql;
        --
        -- FUNCTION Diverse Trigger (Storniert, invalidmessages, picndoku, cache)
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_500_iu__done_storniert() RETURNS TRIGGER AS $$
            BEGIN
             IF new.p_storno THEN
                new.p_done         := True; --new.p_storno; Trigger wird nur im TRUE Fall aufgerufen
                new.p_storno_datum := COALESCE(new.p_storno_datum, current_date);
              END IF;
             --
             IF tg_op = 'UPDATE' THEN -- done True > False, Storno aufheben
                IF old.p_done AND NOT new.p_done THEN --Erledigt wird aufgehoben, auch storniert rückgängig
                   new.p_storno     := False;
                END IF;
                IF old.p_storno AND NOT new.p_storno THEN --Erledigt wird aufgehoben, auch storniert rückgängig
                   new.p_storno_datum := NULL;
                END IF;            
              END IF;
             --
             RETURN new;
            END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_700_iu__invalidmessages() RETURNS TRIGGER AS $$
            BEGIN
             IF (SELECT true FROM steutxt WHERE steu_z = new.p_steu_code AND steu_valid_to < current_date) THEN
                IF new.p_seu_code IS DISTINCT FROM (SELECT k_steu_code FROM TSystem_Wawi.beleg_k WHERE k_id = new.p_k_id) THEN -- Wenn gleich, hat Kopf bereits Nachricht geworfen
                    PERFORM PRODAT_TEXT(15810); --Steuer abgelaufen / Ungültig
                END IF;
             END IF;
             RETURN new;
            END $$ LANGUAGE plpgsql;
           -- Folgendes: TODO klärung Datenmigration?! Muß aktiv sein ja/nein?
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_700_iu__picndoku_keyword() RETURNS TRIGGER AS $$ -- TODO klären: ist das vollständig?
              BEGIN
               UPDATE picndoku SET pd_id = pd_id FROM TSystem_Wawi.beleg_k k WHERE pd_dbrid = k.dbrid AND k_id = new.p_k_id;
               RETURN new;
              END $$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION tcache.beleg_p__cache_reset__d() RETURNS TRIGGER AS $$
              BEGIN
                PERFORM tcache.function_cache_setdirty_1param('beleg_p__pos_wert_calc', old.p_id); --TODO: DELETE (DailyDBFunction?)
                --
                -- PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', old.p_id);
                --
                RETURN old;
              END $$ LANGUAGE plpgsql;   
        --
        -- AFTER TRIGGER MENGEN PROPAGATE Weitergabe von übernommenen Mengen > Rechnung > Lieferschein > Auftrag/Bestellung
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_260_iud__mengelf__propagate_refresh() RETURNS TRIGGER AS $$
            BEGIN
              IF (tg_op = 'DELETE') THEN                     
                IF (old.p_tablename = 'rechnunge') THEN
                  PERFORM TBeleg.Update_ldsdokStkf(old.pre_ld_id);
                  PERFORM TBeleg.Update_wendatStkf(old.pre_w_wen);
                 END IF;
                --    
                IF (old.p_tablename = 'lieferscheinv') THEN      
                  PERFORM TSystem_Wawi.beleg_p__verkauf__mengelf__refresh(old.plv_verkauf_p_id);
                  --Lieferscheinpos. löschen => Lagerabgang wieder für Übernahmen öffnen. l_belp_id ist ON DELETE SET NULL. lifsch trigger setzt dann l_inliefdok zurück.
                 END IF;
                --
                IF (old.p_tablename = 'rechnungv') THEN
                  PERFORM TSystem_Wawi.beleg_p__lieferscheinv__mengef__refresh(old.prv_lieferscheinv_p_id);
                  PERFORM TSystem_Wawi.beleg_p__verkauf__mengelf__refresh(old.prv_verkauf_p_id);
                 END IF;
                --
              ELSE -- INSERT OR UPDATE. Hier new, unten Prüfen auf OLD distinct NEW
                --  
                IF (new.p_tablename = 'rechnunge') THEN
                  PERFORM TBeleg.Update_ldsdokStkf(new.pre_einkauf_p_id);
                  PERFORM TBeleg.Update_wendatStkf(new.pre_w_wen);
                 END IF;
                --
                IF (new.p_tablename = 'lieferscheinv') THEN  
                  PERFORM TSystem_Wawi.beleg_p__verkauf__mengelf__refresh(new.plv_verkauf_p_id);                  
                 END IF;
                --           
                IF (new.p_tablename = 'rechnungv') THEN
                  -- NOT (new.p_k_code = 'P') OR (new.p_k_code = 'G') OR (new.p_k_code = 'T') -- da gibts nie etwas im Lieferschein > siehe Altcode
                  PERFORM TSystem_Wawi.beleg_p__lieferscheinv__mengef__refresh(new.prv_lieferscheinv_p_id);
                  PERFORM TSystem_Wawi.beleg_p__verkauf__mengelf__refresh(new.prv_verkauf_p_id);
                 END IF;      
              END IF;
              --
              IF (tg_op = 'UPDATE') THEN -- OLD IS DISTINCT NEW; NEW ist immer durch obiges (Insert ODER Update) bereits abgefangen                
                IF (new.p_tablename = 'rechnunge') THEN
                  IF (old.pre_ld_id IS DISTINCT FROM new.pre_ld_id) THEN PERFORM TBeleg.Update_ldsdokStkf(old.pre_ld_id); END IF;
                  IF (old.pre_w_wen IS DISTINCT FROM new.pre_w_wen) THEN PERFORM TBeleg.Update_wendatStkf(old.pre_w_wen); END IF;
                 END IF;
                --    
                IF (new.p_tablename = 'lieferscheinv') THEN      
                  IF (old.plv_verkauf_p_id IS DISTINCT FROM new.plv_verkauf_p_id) THEN PERFORM TSystem_Wawi.beleg_p__verkauf__mengelf__refresh(old.plv_verkauf_p_id); END IF;
                  --Lieferscheinpos. löschen => Lagerabgang wieder für Übernahmen öffnen. l_belp_id ist ON DELETE SET NULL. lifsch trigger setzt dann l_inliefdok zurück.
                 END IF;
                --    
                IF (new.p_tablename = 'rechnungv') THEN      
                  IF (old.prv_lieferscheinv_p_id IS DISTINCT FROM new.prv_lieferscheinv_p_id) THEN PERFORM TSystem_Wawi.beleg_p__lieferscheinv__mengef__refresh(old.prv_lieferscheinv_p_id); END IF;
                  IF (old.prv_verkauf_p_id IS DISTINCT FROM new.prv_verkauf_p_id) THEN PERFORM TSystem_Wawi.beleg_p__verkauf__mengelf__refresh(old.prv_verkauf_p_id); END IF;
                  --Lieferscheinpos. löschen => Lagerabgang wieder für Übernahmen öffnen. l_belp_id ist ON DELETE SET NULL. lifsch trigger setzt dann l_inliefdok zurück.
                 END IF;
               END IF;           
               --        
             RETURN new;
            END $$ LANGUAGE plpgsql;
            --       
        --  
        
        -- ################## Haupt und Unterpositionen ############################ -- Wenn Preise: -- Requires TWawi.beleg_p da sowohl Parent/Child sowie Preise errofrderlich    
           -- FUNCTION TSystem_Wawi.beleg_p__p_id__subpos_list > List der Unterpositions-Id
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__p_id__subpos_list(pid INTEGER, stopif_sumsubpos BOOL) RETURNS SETOF INTEGER AS $$
             DECLARE r1 RECORD;
                     r2 RECORD;
             BEGIN
              FOR r1 IN SELECT p_id, p_preis_sumsubpos FROM twawi.beleg_p WHERE p_parent_p_id = pid LOOP
                    RETURN NEXT r1.p_id;
                    IF stopif_sumsubpos AND r1.p_preis_sumsubpos THEN
                    ELSE
                            FOR r2 IN SELECT * FROM TSystem_Wawi.beleg_p__p_id__subpos_list(r1.p_id, stopif_sumsubpos) LOOP
                                    RETURN NEXT r2.beleg_p__p_id__subpos_list;
                            END LOOP;
                    END IF;
              END LOOP;
              RETURN;
             END $$ LANGUAGE plpgsql;
        -- Haupt und Unterpositionen > Setzen p_parent_p_id usw > beleg_p__p_id__mainpos | beleg_p__pos_wert_calc
           -- FUNCTION  beleg_p__p_id__mainpos  >  HauptPosId zurückgeben   
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__p_id__mainpos(_current_p_parent_p_id INTEGER,  -- Trennen wenn nicht werthaltig und dennoch Haupt/Subpos
                _suche_sumsubpos_parent                   boolean = false, --Nächst-Übergeordneten Gruppenknoten
                _suche_top_sumsubpos_parent               boolean = false ) 
                RETURNS INTEGER AS $$
                 DECLARE 
                    _parent_beleg_p_record                Record; --TWawi.beleg_p;
                 BEGIN
                  
                    IF ( _suche_sumsubpos_parent IS FALSE and _suche_top_sumsubpos_parent IS TRUE ) THEN --'illegal flag combination'
                       raise exception 'illegal flag combination';
                     END IF;
                    
                    IF ( _current_p_parent_p_id IS NULL ) THEN --Return Null
                       return null;
                     END IF;
                    
                    -- parent record auslesen
                    SELECT * INTO _parent_beleg_p_record FROM TWawi.beleg_p --TWawi.BelegP wegen SumSubPos 
                                                         WHERE p_id = _current_p_parent_p_id;                                    
                      
                    IF _parent_beleg_p_record is null THEN            
                       -- der foreignkey constraint wurde durch abgeschaltene trigger umgang und der datenzustand
                       -- ist nicht konsistent, daher 23503 »foreign_key_violation«
                       raise exception 'parent_non_existent' USING ERRCODE = 23503;              
                     END IF;
                  
                    --  entspricht ag_vkptotalpos = true
                    IF ( _suche_sumsubpos_parent IS FALSE ) THEN
                      RETURN _parent_beleg_p_record.p_id;
                    END IF;
                    
                    IF ( _suche_top_sumsubpos_parent ) THEN
                      
                      -- über mir kein nicht werthaltiger parent mehr existent
                      -- dann bin ich die höchste nicht werthaltige position
                      IF ( _parent_beleg_p_record.p_preis_sumsubpos and TSystem_Wawi.beleg_p__p_id__mainpos( _parent_beleg_p_record.p_parent_p_id, _suche_sumsubpos_parent ) IS NULL ) THEN
                        RETURN _parent_beleg_p_record.p_id;
                      END IF;
                      
                      -- suche weiter oben weiter
                      RETURN
                        TSystem_Wawi.beleg_p__p_id__mainpos( 
                            _parent_beleg_p_record.p_parent_p_id, 
                            _suche_sumsubpos_parent,
                            _suche_top_sumsubpos_parent 
                        );
                      
                    END IF;
                  
                    -- _current_parent ist bereits der werthaltige parent, den wir suchen
                    IF ( _suche_sumsubpos_parent AND _parent_beleg_p_record.p_preis_sumsubpos IS TRUE ) THEN
                       RETURN _parent_beleg_p_record.p_id;
                     END IF;
                    
                    -- wir suchen weiter oben nach werthaltigen parent
                    IF ( _suche_sumsubpos_parent AND _parent_beleg_p_record.p_preis_sumsubpos IS FALSE ) THEN
                       RETURN TSystem_Wawi.beleg_p__p_id__mainpos( _parent_beleg_p_record.p_parent_p_id, _suche_sumsubpos_parent );
                     END IF;
                    
                 END $$ LANGUAGE plpgsql STRICT STABLE;    
           -- Achtung. diesen Wrapper nicht in Triggern nutzen, da der Query Planer nicht damit zurecht kommt das manchmal TWawi.Beleg_p und manchmal TSystem_Wawi.Beleg_p als Input folgt. > PG96 >  ERROR:  type of parameter 5 (record) does not match that when preparing the plan (twawi.beleg_p) 
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__p_id__mainpos(_current_beleg_p TSystem_Wawi.beleg_p, -- Trennen wenn nicht werthaltig und dennoch Haupt/Subpos
                _suche_sumsubpos_parent                   boolean = false, --Nächst-Übergeordneten Gruppenknoten
                _suche_top_sumsubpos_parent               boolean = false ) 
                RETURNS INTEGER AS $$
             BEGIN
              RETURN TSystem_Wawi.beleg_p__p_id__mainpos(_current_beleg_p.p_parent_p_id, _suche_sumsubpos_parent, _suche_top_sumsubpos_parent);
             END $$ LANGUAGE plpgsql STRICT STABLE;   
           --
           -- Trigger HauptPos / SubPos - schreiben p_parent_pos bzw. p_parent_p_id; Muß vor Preisen, die diese die Struktur-Infos benötigen
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__b_105_iu__parent__hpos() RETURNS TRIGGER AS $$
             DECLARE parent_p_id INTEGER;
             BEGIN
              --
              IF tg_op = 'UPDATE' THEN
                 -- Parent über Änderung der Positionsnummer verschieben. ParentId nicht > Pos ist führend.
                 IF new.p_parent_p_id IS NOT DISTINCT FROM old.p_parent_p_id AND new.p_parent_pos IS DISTINCT FROM old.p_parent_pos THEN --
                    new.p_parent_p_id := NULL;
                 END IF;
              END IF;
              --
              IF new.p_parent_p_id IS NOT NULL THEN
                  new.p_parent_pos := p_pos FROM TSystem_Wawi.beleg_p WHERE p_id = new.p_parent_p_id;
               ELSE
                  IF new.p_parent_pos IS NOT NULL THEN
                     new.p_parent_p_id := p_id FROM TSystem_Wawi.beleg_p WHERE p_k_id = new.p_k_id AND p_pos = new.p_parent_pos;
                  END IF;
              END IF;
              --
              IF new.p_parent_p_id IS NOT NULL THEN
                 IF new.p_parent_p_id IN (SELECT * FROM TSystem_Wawi.beleg_p__p_id__subpos_list(new.p_id, false)) THEN --Kreisaufruf: mein neuer Parent ist zugleich eine Unterposition von mir
                    RAISE EXCEPTION 'parent_pos % is also subpos of %', new.p_parent_pos, new.p_pos;
                  END IF;
               END IF;
              --
              RETURN new;
             END $$ LANGUAGE plpgsql;
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_105_u__parent__hpos() RETURNS TRIGGER AS $$ -- Änderung der Positionsnummer (umnummerieren) an Unterposition weitergeben
             DECLARE parent_p_id INTEGER;
             BEGIN
              --
              IF tg_op = 'UPDATE' THEN
                 -- Positionsnummer umschreiben, dann das an die Unterpositionen weitergeben und weg.
                 IF new.p_pos IS DISTINCT FROM old.p_pos THEN --ACHTUNG: Pos, NICHT Parent_Pos
                    UPDATE TSystem_Wawi.beleg_p SET p_parent_pos = new.p_pos WHERE p_parent_p_id = new.p_id;
                    RETURN new;
                 END IF;
              END IF;
              --
              RETURN new;
             END $$ LANGUAGE plpgsql;     
           --
           -- Ab hier Werteberechnung
           -- Positionswert anhand Parameter (Offen, alle usw)  erhalten >> FUNCTION TSystem_Wawi.beleg_p__pos_wert_calc
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__pos_wert_calc(
                pid INTEGER, 
                offen BOOL = FALSE, 
                basis_w BOOL = FALSE,
                withtotalpos BOOL = false,
                forceOptionalposWert BOOL = false,
                forceStornoPosWert BOOL = false,
                withgesrab BOOL = true
              ) RETURNS NUMERIC(16,4) AS $$
        
              DECLARE 
                rec_p  RECORD;
                preis_gme_rabatt NUMERIC(16,4);
                abzu   NUMERIC(16,4);
                result NUMERIC(16,4);          
              BEGIN
                IF offen THEN
                   RAISE EXCEPTION 'offen not yet implemented'; --Vorkommen dieses Strings prüfen!
                END IF;
        
                -- caching
                -- dies ist nur false, wenn HauptPos nach Unterpos gerechnet wird. Diese Zwischensumme ohne GesRab wird NIE gespeichert
                IF withgesrab THEN 
                   SELECT c_resultn INTO result FROM tcache.function_cache WHERE c_funcname = 'beleg_p__pos_wert_calc' AND c_param0=pid AND c_param1::BOOL=offen AND c_param2::BOOL=basis_w AND c_param3::BOOL=withtotalpos AND c_param4::BOOL=forceOptionalposWert AND c_param5::BOOL=forceStornoPosWert AND NOT c_dirty;
                   IF result IS NOT NULL THEN
                      RETURN result;
                   END IF;
                END IF;
        
                SELECT 
                  --k_code,
                  p_id,
                  p_pos, 
                  CASE WHEN offen THEN
                         0 -- p_menge_gme - GREATEST( p_mengel_gme, p_mengef_gme, 0 ) 'offen not yet implemented'
                     ELSE
                         p_menge_gme 
                  END AS menge_gme, 
                  p_preis_gme, 
                  p_waer_kurs,
                  p_rabatt,
                  p_rabatt_gesamt,
                  p_rabatt_able,
                  TSystem_Wawi.beleg_p__p_id__mainpos( beleg_p.p_parent_p_id, True ) AS totalpospid,
                  p_wert_netto,
                  p_wert_netto_gwaer,
                  p_wert_abzu_netto,
                  p_wert_abzu_netto_gwaer,
                  -- p_wert_abzuk_netto,
                  -- p_wert_abzuk_netto_gwaer,
                  --
                  p_preis_sumsubpos,
                  p_done,
                  p_storno,
                  p_nstatistik
                INTO rec_p
                FROM twawi.beleg_p 
                --LEFT JOIN auftgtxt ON at_astat = ag_astat AND at_nr = ag_nr 
                --LEFT JOIN auftgdokutxt ON atd_dokunr = ag_dokunr 
                WHERE p_id = pid;
                --        
                -- achtung - haupt und unterpositionen - Poswertverteilung
                IF (offen AND rec_p.p_done) OR (rec_p.p_storno AND NOT forceStornoPosWert) OR (rec_p.p_nstatistik AND NOT forceoptionalposwert) THEN 
                    PERFORM tcache.function_cache_setcache_beleg_p__pos_wert_calc(pid, offen, basis_w, withtotalpos, forceOptionalposWert, forceStornoPosWert, 0);
                    RETURN 0;
                END IF;        
                --
                IF rec_p.p_preis_sumsubpos AND NOT withtotalpos THEN
                   -- Preis enthält Unterposition, es muß Unterposition geben, sonst ist der Preis vollständig gültig
                   IF EXISTS( SELECT true FROM twawi.beleg_p WHERE p_parent_p_id = rec_p.p_id) THEN 
                      PERFORM tcache.function_cache_setcache_beleg_p__pos_wert_calc(pid, offen, basis_w, withtotalpos, forceOptionalposWert, forceStornoPosWert, 0);
                      RETURN 0;
                   END IF;
                END IF;
                --       
                IF offen THEN
                   RAISE EXCEPTION 'offen not yet implemented'; --WHERE az_ag_id = agid AND IFTHEN( NOT offen, TRUE, az_bebnr IS NULL ); TODO
                  ELSE
                   IF basis_w THEN
                      abzu := rec_p.p_wert_abzu_netto_gwaer; -- + p_wert_abzuk_netto_gwaer;
                     ELSE
                      abzu := rec_p.p_wert_abzu_netto; -- + p_wert_abzuk_netto;
                   END IF;
                END IF;         
                --
                abzu := COALESCE(abzu, 0);
                IF offen AND rec_p.menge_gme < 0 THEN
                    PERFORM tcache.function_cache_setcache_beleg_p__pos_wert_calc(pid, offen, basis_w, withtotalpos, forceOptionalposWert, forceStornoPosWert, abzu); 
                    RETURN 0 + abzu;
                END IF;
        
                -- wenn Hauptposition auf gleichem Dokument wie Unterposition, werden alle gleichartig angetriggert und die Hauptpositiion und die Unterspositionen sehen alle den Gesamtrabatt
                -- wenn HauptPos und unterPost ungleich auf dem Dokument stehen, sehen diese unterschiedlich den Rabatt
                -- => Unterpositionen ziehen Ihren Rabatt immer aus der Hauptposition, unabhängig von der Dokumentzuweisung
                IF NOT withgesrab OR rec_p.totalpospid IS NOT NULL THEN
                   rec_p.p_rabatt_gesamt := 0;
                END IF;
                --      
                IF rec_p.p_rabatt_able THEN
                    preis_gme_rabatt := rec_p.p_preis_gme * ( 1 - COALESCE(rec_p.p_rabatt, 0) / 100 ) * ( 1 - COALESCE(rec_p.p_rabatt_gesamt, 0) / 100 );
                 ELSE
                    -- nicht rabattfähig
                    preis_gme_rabatt := rec_p.p_preis_gme;
                END IF;
                --
                IF basis_w THEN
                   preis_gme_rabatt := preis_gme_rabatt * rec_p.p_waer_kurs;
                END IF;
                
                result := preis_gme_rabatt * rec_p.menge_gme + COALESCE(abzu, 0);
        
                IF withgesrab THEN --dies ist nur false, wenn HauptPos nach Unterpos gerechnet wird. Diese Zwischensumme ohne GesRab wird NIE gespeichert
                   PERFORM tcache.function_cache_setcache_beleg_p__pos_wert_calc(pid, offen, basis_w, withtotalpos, forceOptionalposWert, forceStornoPosWert, result);
                END IF;
        
                RETURN result;
                
              END $$ LANGUAGE plpgsql STABLE;   
           -- HauptPosition berechnet Werte aus Unterpositionen neu >> FUNCTION TSystem_Wawi.beleg_p__recalcmainposwert
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__recalcmainposwert(mainpid INTEGER) RETURNS NUMERIC(16,4) AS $$
              DECLARE preisupos NUMERIC(16,4);
                      anzupos NUMERIC(16,4);
                      abzunetto NUMERIC(16,4); 
                      vkptotalpos BOOL;
                      mainposisopt BOOL;
                      stornopos BOOL;
                      result NUMERIC(16,4);
              BEGIN
                IF (COALESCE(mainpid, 0) = 0) /*OR TSystem_Wawi.beleg_p__trigger__totalposwert__disabled__is() das einfügen und mehrdimensional geht nicht nach oben weiter*/ THEN -- Disabled_Is: Klärung! TODO https://ci.prodat-sql.de/sources/tests/suite/13/runner/120 > canrabatt
                    RETURN 0;
                END IF;
                --
                SELECT p_nstatistik, p_storno INTO mainposisopt, stornopos FROM twawi.beleg_p WHERE p_id = mainpid;
                -- VKP-Summe und Anzahl der Unterpositionen 
                SELECT SUM(TSystem_Wawi.beleg_p__pos_wert_calc(p_id, false, false, true, mainposisopt, stornopos)), COUNT(1) INTO preisupos, anzupos 
                    FROM twawi.beleg_p WHERE p_id IN (SELECT * FROM TSystem_Wawi.beleg_p__p_id__subpos_list(mainpid, true)) AND (p_nstatistik = mainposisopt) AND (p_storno = stornopos);
                -- Abzuschläge der hauptposition abziehen
                abzunetto := p_wert_abzu_netto FROM twawi.beleg_p WHERE p_id = mainpid;    
                preisupos := preisupos-COALESCE(abzunetto,0);
                --
                -- Wir aktualisieren uns jetzt selbst. Um zu verhindern, das wir Unterpositionen aktualisieren die dann wieder im Kreis zurückschreiben wollen, flaggen
                PERFORM TSystem_Wawi.beleg_p__trigger__totalposwert__disable();
                --    
                UPDATE TWawi.beleg_p SET 
                    p_preis =                  ( COALESCE( preisupos, 0 ) / IFTHEN( p_rabatt_able, ( 1 - p_rabatt / 100 ), 1) / p_menge ) --p_rabatt_gesamt ? in beleg_p__pos_wert_calc gegengerechnet ? könnte man auflösen und hier aufnehmen?
                  WHERE
                    p_preis   IS DISTINCT FROM ( COALESCE( preisupos, 0 ) / IFTHEN( p_rabatt_able, ( 1 - p_rabatt / 100 ), 1 ) / p_menge)
                   AND
                    p_id    = mainpid AND p_menge>0
                  RETURNING p_preis INTO result;
                --
                PERFORM TSystem_Wawi.beleg_p__trigger__totalposwert__enable();
                --
                RETURN result;
              END $$ LANGUAGE plpgsql;       
        
           -- Hauptposition gibt Wertänderung an Unterpositionen durch >> FUNCTION TSystem_Wawi.beleg_p__a_35_u__werte__hauptsubpos
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_350_u__werte__hauptsubpos() RETURNS TRIGGER AS $$
                      DECLARE 
                        wertupos NUMERIC(16,4);
                        anzupos NUMERIC(16,4);
                        rundabweichung NUMERIC(16,4);
                        mainpid INTEGER;
                        grab NUMERIC;
                        pwCalc NUMERIC(16,4);
                        self_is_subtotalpos_with_toppos BOOL;
                      BEGIN
                        --
                        IF new.p_preis_sumsubpos AND NOT old.p_preis_sumsubpos THEN -- Position wird neu zu totalpos > wir geben unseren Wert nicht nach unten (0) sondern nehmen den Wert von Unten an
                            PERFORM TSystem_Wawi.beleg_p__recalcmainposwert( new.p_id );
                            RETURN new;
                         END IF;
                        -- wir werden durch eine Unterposition aktualisiert, dann geben wir uns selbst nicht wieder nach unten
                        -- wird auch in recalcmainposwert gesetzt
                        IF TSystem_Wawi.beleg_p__trigger__totalposwert__disabled__is() THEN
                            --Rekursion nach oben    
                            IF new.p_parent_p_id IS NOT NULL THEN 
                                PERFORM TSystem_Wawi.beleg_p__recalcmainposwert( TSystem_Wawi.beleg_p__p_id__mainpos( new.p_parent_p_id, true ) );
                            END IF;
                            -- Im Fall ich bin selbst eine Totalposition muß ich meine Änderung nach unten weitergeben. Fall: Level 0 aktualisiert Level 1 aktualisiert Level 2
                            IF NOT new.p_preis_sumsubpos THEN
                               RETURN new;
                            END IF;
                         END IF;    
        
                        --
                        --Gesamtrabatt
                        grab := ( 1 - COALESCE(new.p_rabatt_gesamt, 0) / 100);
                        self_is_subtotalpos_with_toppos := False;
                        --
                        -- wir sind eine vkptotal-Unterposition : wichtig hinsichtlich Gesamtrabatt
                        IF TSystem_Wawi.beleg_p__p_id__mainpos( new.p_parent_p_id, true, true) IS NOT NULL THEN 
                           -- ich selbst bin in einer anderen Position enthalten. Daher bin ich durch die obere Position bereits 
                           -- gesamtrabattiert und muß entsprechend die Unterpositionen auch entgegengesetzt nehmen       
                           self_is_subtotalpos_with_toppos := True; 
                           grab := 1;
                         END IF;
        
                        -- Wert aktueller Position    
                        -- enthält bereits gesamtrabatt, daher aus Unterpositionen herausrechnen
                        pwCalc := TSystem_Wawi.beleg_p__pos_wert_calc( new.p_id, false, false, true, new.p_nstatistik, new.p_storno, NOT self_is_subtotalpos_with_toppos) / grab; 
                        -- Wert aller umsatzwirksamen Unterpositionen, ACHTUNG: ohne Gesamtrabatt. Wichtig, wenn Positionen teilweise im gleichen Dokument wie Hauptposition  
                        SELECT --Summe und Anzahl der Unterpositionen ermitteln
                                SUM( TSystem_Wawi.beleg_p__pos_wert_calc(p_id, false, false, true, new.p_nstatistik, new.p_storno, False) ), --Summe der Unterpositionen 
                                COUNT(1)
                           INTO wertupos, anzupos 
                           FROM twawi.beleg_p
                           WHERE 
                              p_id IN ( SELECT * FROM TSystem_Wawi.beleg_p__p_id__subpos_list(new.p_id, True) )
                                    AND ( NOT p_nstatistik OR new.p_nstatistik) 
                                    AND p_storno = new.p_storno;                                                          
                        -- 
                        PERFORM TSystem_Wawi.beleg_p__trigger__totalposwert__disable();
                        -- ####### Eigentliches Übergeben der Werte #######
                        -- Wenn Unterpos. Preise haben, Hauptpositionspreis wert-anteilig auf Unterpositionen aufteilen und da reinschreiben 
                        -- Einmal anhand der Positionswerte verteilen. Gibt es keine Werte wird anhand der Anzahl verteilt
                        IF COALESCE( wertupos, 0 ) > 0 THEN -- "UPDATE twawi.beleg_p" 
                            UPDATE twawi.beleg_p
                                    SET 
                                        p_preis = pwCalc / Do1If0(wertupos) * p_preis  -- beachte unten: is distinct from
                                    WHERE 
                                        p_id IN (SELECT * FROM TSystem_Wawi.beleg_p__p_id__subpos_list( new.p_id, True ) ) 
                                            AND ( NOT p_nstatistik OR new.p_nstatistik) 
                                            AND (p_preis IS DISTINCT FROM pwCalc / Do1If0(wertupos) * p_preis)
                                            AND p_storno = new.p_storno;
                         ELSE 
                            -- Wenn Unterpos. keinen Preis haben, Hauptpositionspreis nach Anzahl der Unterpostionen aufteilen und da reinschreiben                        
                            UPDATE twawi.beleg_p
                                    SET 
                                        p_preis = pwCalc / Do1If0(anzupos)  -- beachte unten: is distinct from     
                                    WHERE 
                                        p_id IN ( SELECT * FROM TSystem_Wawi.beleg_p__p_id__subpos_list( new.p_id, True ) ) 
                                            AND ( NOT p_nstatistik OR new.p_nstatistik) 
                                            AND (p_preis IS DISTINCT FROM pwCalc / Do1If0(anzupos))
                                            AND p_storno = new.p_storno;
                         END IF;
        
                        -- Rundungsabweichung "UPDATE twawi.beleg_p"
                         -- Neu durchrechen nach Aktualisierung
                         SELECT -- Ermitteln Rundungsabweichung
                                 SUM( TSystem_Wawi.beleg_p__pos_wert_calc(p_id, false, false, true, new.p_nstatistik, new.p_storno, False) )
                            INTO wertupos 
                            FROM twawi.beleg_p
                            WHERE 
                                 p_id IN ( SELECT * FROM TSystem_Wawi.beleg_p__p_id__subpos_list(new.p_id, True) ) 
                                     AND ( NOT p_nstatistik OR new.p_nstatistik ) 
                                     AND p_storno = new.p_storno;
                                                             
                         -- Wieder Hauptpos. - Summe(aller Unterpos) wegen Rundungsfehlern 
                         rundabweichung := pwCalc - wertupos;                 
                         IF rundabweichung <> 0 THEN -- Rundungsabweichung auflösen .. UPDATE twawi.beleg_p
                            UPDATE twawi.beleg_p
                                    SET 
                                        p_preis  = p_preis + rundabweichung / Do1If0(p_menge)
                                    WHERE 
                                          p_id = (
                                              SELECT p_id FROM TSystem_Wawi.beleg_p__p_id__subpos_list(new.p_id, True) 
                                              JOIN twawi.beleg_p ON p_id = beleg_p__p_id__subpos_list
                                              WHERE 
                                                    p_menge > 0 AND ( NOT p_nstatistik OR new.p_nstatistik )
                                                AND p_storno = new.p_storno 
                                              ORDER BY p_menge
                                              LIMIT 1
                                          );
                         END IF;
                        -- Ende Rundungsabweichung
                        PERFORM TSystem_Wawi.beleg_p__trigger__totalposwert__enable();
                        --
                        RETURN new;   
                      END $$ LANGUAGE plpgsql;
           -- Unterpositionen geben Änderung an Hauptposition nach oben >> FUNCTION TSystem_Wawi.beleg_p__a_35_iud__subposhauptpos
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_350_iu__werte__subposhauptpos() RETURNS TRIGGER AS $$
                  DECLARE 
                    _mainpos_p_id INTEGER;
                  BEGIN
                    --Eine Unterposition wird aus einer Hauptposition herausgezogen, Hauptposition neu berechnen
                    IF tg_op = 'UPDATE' THEN
                        IF ( old.p_parent_p_id IS NOT NULL ) AND ( new.p_parent_p_id IS DISTINCT FROM old.p_parent_p_id ) THEN        
                            BEGIN
                              _mainpos_p_id := TSystem_Wawi.beleg_p__p_id__mainpos( old.p_parent_p_id, true );
                            EXCEPTION
                            
                              -- im normalfall wird eine unterposition von einer position »a« nach »b« umgezogen
                              --     a   b             a   b
                              --      \      hin zu:      /
                              --       c                 c
                              -- für diesen fall ist die verwendung von old korrekt.
                              -- wenn aber für »a« die ag_pos geändert wird, wird die via update cascade für position »c« die ag_hpos durchgereicht.
                              -- durch die triggerverwendung entsteht ein inkonsistenter datenzustand 'zwischen' den triggerphasen
                              -- daher die sonderbehandlung an der stelle, weil in diesem kontext die mainpos für auftg auf new gehen müsste,
                              -- was wiederrum hier nicht zu erkennen ist, ob ich auf new oder old muss. daher schlägt die selectierung des korrekten parent fehl
                              -- was aber nicht weiter relevant ist, da die positionen gemeinsam umgesetzt werden und es keiner neuberechnung bedarf.
                              
                              WHEN SQLSTATE '23503' THEN
                                _mainpos_p_id := null;
                            END;            
                            --wenn wir schieben sich aber in der Hauptpostion nichts ändert, wir ändern zB nur eine Reihenfolge
                            IF _mainpos_p_id = TSystem_Wawi.beleg_p__p_id__mainpos( new.p_parent_p_id, true ) THEN
                                RETURN new;
                            END IF;
                            --
                            PERFORM TSystem_Wawi.beleg_p__recalcmainposwert( _mainpos_p_id );
                        END IF;        
                    END IF;    
                    -- Eine Unterposition wird in eine Hauptposition hineingezogen, oder sie ändert ihren Wert oder wird storniert
                    IF new.p_parent_p_id IS NOT NULL THEN 
                       PERFORM TSystem_Wawi.beleg_p__recalcmainposwert( TSystem_Wawi.beleg_p__p_id__mainpos(new.p_parent_p_id, true) );
                    END IF;
                    --
                    RETURN new;
                  END $$ LANGUAGE plpgsql;   
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__a_350_d__werte__subposhauptpos() RETURNS TRIGGER AS $$
               BEGIN      
                 PERFORM TSystem_Wawi.beleg_p__recalcmainposwert( TSystem_Wawi.beleg_p__p_id__mainpos( old.p_parent_p_id, true ) ); 
                 RETURN old;
               END $$ LANGUAGE plpgsql;
        --      
        
        -- TRIGGER CREATE FUNCTION TRIGGER BEFORE ATER Mengen belegpos menge__uf, HauptPosSubPos>> FUNCTION zum Erstellen Grundtrigger
           CREATE FUNCTION TSystem_Wawi.beleg_p__trigger__menge_uf__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
              DECLARE 
                aknr_frei VARCHAR;
                tname text = _schema_name || '.' || _table_name;
              BEGIN
               aknr_frei := '';           
               IF tsystem.column_exists(_table_name, 'p_aknr_frei', _schema_name ) THEN -- Preiseinheit, Preismengeneinheit, Preis in GME
                   aknr_frei := ', p_aknr_frei';
                   EXECUTE $$
                   CREATE TRIGGER b_153_iu__aknr_frei
                    BEFORE INSERT OR UPDATE
                    OF p_aknr, p_aknr_frei -- Mengeneinheitsänderung > neuer preis_gme
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_153_iu__aknr_frei();
                    $$;
               END IF;
               IF tsystem.column_exists(_table_name, 'p_aknr', _schema_name ) THEN -- Preiseinheit, Preismengeneinheit, Preis in GME
                   EXECUTE $$
                   CREATE TRIGGER b_155_iu__aknr
                    BEFORE INSERT OR UPDATE
                    OF p_aknr, p_me --Mengeneinheitsänderung > neuer preis_gme
                       $$ || aknr_frei || $$ -- change freie aknr entfernt evtl richtige aknr / me
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_155_iu__aknr();
                    $$;
               END IF;
               EXECUTE $$ --TRIGGER b_220_iu__menge__uf
                  CREATE TRIGGER b_220_iu__menge__uf
                    BEFORE INSERT OR UPDATE
                    OF p_menge
                       , p_me
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_220_iu__menge__uf();             
                $$;
               IF lower(tname) IN ('twawi.beleg_p__lieferscheinv', 'twawi.beleg_p__rechnungv', 'twawi.beleg_p__rechnunge') THEN
                  EXECUTE $$
                    CREATE TRIGGER a_260_iuX__mengelf__propagate_refresh
                     AFTER INSERT OR UPDATE
                     OF p_menge, p_me
                     ON $$ || tname || $$ --TWawi.beleg_p__lieferscheinv
                     FOR EACH ROW
                     EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_260_iud__mengelf__propagate_refresh();
                    
                    CREATE TRIGGER a_260_XXd__menge__propagate_refresh
                     AFTER DELETE
                     ON $$ || tname || $$ --TWawi.beleg_p__lieferscheinv
                     FOR EACH ROW
                     EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_260_iud__mengelf__propagate_refresh();        
                   $$;
                END IF;
               RETURN;
              END $f$ LANGUAGE plpgsql;
        
        -- TRIGGER CREATE FUNCTION beleg_p / beleg_p__trigger__all__create
           CREATE FUNCTION TSystem_Wawi.beleg_p__trigger__wert__before__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
              DECLARE
                tname text = _schema_name || '.' || _table_name;
              BEGIN
               IF tsystem.column_exists(_table_name, 'p_preis_me', _schema_name ) THEN -- Preiseinheit, Preismengeneinheit, Preis in GME
                   EXECUTE $$
                   CREATE TRIGGER b_320_iu__wert__pe_gme__calculate
                    BEFORE INSERT OR UPDATE
                    OF p_me --Mengeneinheitsänderung > neuer preis_gme
                       , p_preis, p_preis_in_pe, p_preis_me, p_preis_pe
                       , p_wert_netto, p_wert_abzu_netto  -- Summe aktualisieren TODO -  besser Funktion erstellen wegen Kreisaurruf?!
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_320_iu__wert__pe_gme__calculate();
                    $$;
                END IF;
               -- Dieser Trigger IMMER : Preis_base
                   EXECUTE $$
                   CREATE TRIGGER b_340_iu__wert__base__calculate -- Preis * Menge = Wert
                    BEFORE INSERT OR UPDATE
                    OF p_menge
                       , p_preis $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_preis_me',_schema_name), ', p_preis_in_pe, p_preis_me, p_preis_pe', '') ||$$
                       , p_wert_netto, p_wert_abzu_netto  -- Summe aktualisieren TODO -  besser Funktion erstellen wegen Kreisaurruf?!
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_340_iu__wert__base__calculate(); 
                    $$;
               -- Rabattierung
               IF tsystem.column_exists( _table_name, 'p_rabatt', _schema_name ) THEN -- 
                   EXECUTE $$
                   CREATE TRIGGER b_350_iu__wert__rabatt__calulate --Grundtrigger anhängen
                    BEFORE INSERT OR UPDATE
                    OF p_menge
                       , p_me
                       , p_preis $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_preis_me', _schema_name), ', p_preis_in_pe, p_preis_me, p_preis_pe', '') ||$$
                       , p_rabatt, p_rabatt_gesamt, p_rabatt_able
                       , p_parent_p_id, p_parent_pos -- Position wird unter Baum / aus Baum raus : dann den Gesamtrabatt entsprechend aus Kopf übernehmen bzw. entfernen. >> beleg_p__verkauf_a__b_30_iu__wert
                       , p_wert_netto, p_wert_abzu_netto  -- Summe aktualisieren TODO -  besser Funktion erstellen wegen Kreisaurruf?!
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_350_iu__wert__rabatt__calulate();         
                    $$;
                END IF;       
               -- Währung und Kurs
               IF tsystem.column_exists( _table_name, 'p_waer', _schema_name ) THEN -- 
                   EXECUTE $$
                   CREATE TRIGGER b_360_iu__wert__gwaer__calulate --Grundtrigger anhängen
                    BEFORE INSERT OR UPDATE
                    OF p_menge
                       , p_me
                       , p_preis $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_preis_me', _schema_name), ', p_preis_in_pe, p_preis_me, p_preis_pe', '') ||$$
                       , p_rabatt, p_rabatt_gesamt, p_rabatt_able
                       , p_parent_p_id, p_parent_pos -- Position wird unter Baum / aus Baum raus : dann den Gesamtrabatt entsprechend aus Kopf übernehmen bzw. entfernen. >> beleg_p__verkauf_a__b_30_iu__wert
                       , p_waer, p_waer_kurs
                       , p_wert_netto, p_wert_abzu_netto  -- Summe aktualisieren TODO -  besser Funktion erstellen wegen Kreisaurruf?!
                    ON $$ || tname || $$
                    FOR EACH ROW               
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_360_iu__wert__gwaer__calulate();
                    $$;
                END IF;  
               --
               IF tsystem.column_exists( _table_name, 'p_steu_code', _schema_name ) THEN -- Steuern und Brutto
                   EXECUTE $$
                   CREATE TRIGGER b_370_iu__wert__steu_brutto__calculate --Grundtrigger anhängen
                    BEFORE INSERT OR UPDATE
                    OF p_menge
                       , p_me
                       , p_preis $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_preis_me', _schema_name), ', p_preis_in_pe, p_preis_me, p_preis_pe', '') ||$$
                       , p_rabatt, p_rabatt_gesamt, p_rabatt_able
                       , p_parent_p_id, p_parent_pos -- Position wird unter Baum / aus Baum raus : dann den Gesamtrabatt entsprechend aus Kopf übernehmen bzw. entfernen. >> beleg_p__verkauf_a__b_30_iu__wert
                       , p_waer, p_waer_kurs
                       , p_steu_code, p_steu_proz
                       , p_wert_netto, p_wert_abzu_netto  -- Summe aktualisieren TODO -  besser Funktion erstellen wegen Kreisaurruf?!
                    ON $$ || tname || $$
                    FOR EACH ROW               
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_370_iu__wert__steu_brutto__calculate();
                    $$;
                END IF;
               -- Cache Reset - Zusammenstellung der Felder beachten
               EXECUTE $$ CREATE TRIGGER _50__cache_reset__iu
                     BEFORE INSERT OR UPDATE
                     OF p_menge
                       , p_me
                       , p_preis $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_preis_me', _schema_name), ', p_preis_in_pe, p_preis_me, p_preis_pe', '') ||$$
                                 $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_rabatt', _schema_name), ', p_rabatt, p_rabatt_gesamt, p_rabatt_able, p_parent_p_id, p_parent_pos', '') ||$$
                                 -- p_parent_p_id, p_parent_pos  >  bachte Zeile darüber 
                                 $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_waer', _schema_name), ', p_waer, p_waer_kurs', '') ||$$
                                 $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_steu_code', _schema_name), ', p_steu_code, p_steu_proz', '') ||$$
                       , p_wert_netto, p_wert_abzu_netto  -- Summe aktualisieren TODO -  besser Funktion erstellen wegen Kreisaurruf?!
                     ON $$ || tname || $$
                     FOR EACH ROW
                     EXECUTE PROCEDURE TCache.beleg_p__cache_reset__iu();
                     $$;
               --
               RETURN;
              END $f$ LANGUAGE plpgsql;   
           --
           CREATE FUNCTION TSystem_Wawi.beleg_p__trigger__wert__after__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
              declare tname text = _schema_name || '.' || _table_name;
              BEGIN
                -- Achtung: weitere Trigger anAbzuschlags Trigger (Propagate an Abzu) - in abzu_trigger create (falls es keine abzuschläge gibt - auch kein Trigger)
                IF tsystem.column_exists(_table_name, 'p_steu_code', _schema_name) THEN -- Steuern und Brutto
                   EXECUTE $$
                   CREATE TRIGGER a_700_iu__invalidmessages
                    AFTER INSERT OR UPDATE
                    OF p_steu_code
                    ON $$ || tname || $$
                    FOR EACH ROW
                    WHEN (new.p_steu_code IS NOT NULL)
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_700_iu__invalidmessages(); 
                   $$;
                 END IF; 
                --
                IF tsystem.column_exists(_table_name, 'p_preis', _schema_name) THEN -- beleg_p__function__create__propagate__beleg_k Preise aktualisieren Kopfdaten
                   EXECUTE $$               
                   CREATE TRIGGER a_390_iuX__wert__propagate__beleg_k --Grundtrigger anhängen
                    AFTER INSERT OR UPDATE
                    OF p_menge
                       , p_me
                       , p_preis $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_preis_me', _schema_name), ', p_preis_in_pe, p_preis_me, p_preis_pe', '') ||$$
                                 $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_rabatt', _schema_name), ', p_rabatt, p_rabatt_gesamt, p_rabatt_able, p_parent_p_id, p_parent_pos', '') ||$$
                                 -- p_parent_p_id, p_parent_pos  >  bachte Zeile darüber 
                                 $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_waer', _schema_name), ', p_waer, p_waer_kurs', '') ||$$
                                 $$|| IFTHEN (tsystem.column_exists(_table_name, 'p_steu_code', _schema_name), ', p_steu_code, p_steu_proz', '') ||$$
                       , p_wert_netto, p_wert_abzu_netto          -- abzu > Kopf
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_390_iud__wert__propagate__beleg_k$$|| IFTHEN(tsystem.column_exists(_table_name, 'p_steu_code', _schema_name), '__brutto', '__netto') ||$$(); 
                   -- 
                   CREATE TRIGGER a_390_XXd__wert__propagate__beleg_k --Grundtrigger anhängen
                    AFTER DELETE
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_390_iud__wert__propagate__beleg_k$$|| IFTHEN(tsystem.column_exists(_table_name, 'p_steu_code', _schema_name), '__brutto', '__netto') ||$$();           
                   --
                   CREATE TRIGGER _50__cache_reset__d
                    BEFORE DELETE
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE tcache.beleg_p__cache_reset__d();
                   $$;
                END IF;   
               RETURN;
              END $f$ LANGUAGE plpgsql;
           --
           CREATE FUNCTION TSystem_Wawi.beleg_p__trigger__hauptpossubpos__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
             declare tname text = _schema_name || '.' || _table_name;
             BEGIN
              EXECUTE $$
                 CREATE TRIGGER b_105_iu__parent__hpos
                  BEFORE INSERT OR UPDATE -- DELETE im CONSTRAINT (ON DELETE CASCADE)
                    OF p_parent_pos, p_parent_p_id $$ || IFTHEN (tsystem.column_exists(_table_name, 'prv_verkauf_p_parent_pos', _schema_name), ', prv_verkauf_p_parent_pos', '') || $$ 
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_105_iu__parent__hpos();
        
                 CREATE TRIGGER a_105_u__parent__hpos
                  AFTER UPDATE --DELETE im CONSTRAINT
                    OF p_pos --p_pos: Kaskadierende Änderung der Positionsnummer (Positionsnummer umschreiben)
                    ON $$ || tname || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_105_u__parent__hpos();          
              $$; 
              --
              IF tsystem.column_exists( _table_name, 'p_preis', _schema_name ) THEN -- Preise aktualisieren HauptPos SubPos
               EXECUTE $$
                 CREATE TRIGGER a_350_u__werte__hauptsubpos
                  AFTER UPDATE
                    OF p_menge
                       , p_me
                       , p_preis $$|| IFTHEN (tsystem.column_exists( _table_name, 'p_preis_me', _schema_name ), ', p_preis_in_pe, p_preis_me, p_preis_pe', '') ||$$
                                 $$|| IFTHEN (tsystem.column_exists( _table_name, 'p_rabatt', _schema_name ), ', p_rabatt, p_rabatt_gesamt, p_parent_p_id, p_parent_pos', '') ||$$ --p_rabatt_able, 
                                 -- p_parent_p_id, p_parent_pos  >  bachte Zeile darüber 
                                 $$|| IFTHEN (tsystem.column_exists( _table_name, 'p_waer', _schema_name ), ', p_waer, p_waer_kurs', '') ||$$
                                 $$|| IFTHEN (tsystem.column_exists( _table_name, 'p_steu_code', _schema_name ), ', p_steu_code, p_steu_proz', '') ||$$
                       , p_wert_netto, p_wert_abzu_netto          -- abzu > Kopf                       
                       , p_preis_sumsubpos
                    ON $$ || tname || $$
                    FOR EACH ROW
                    WHEN (new.p_preis_sumsubpos)
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_350_u__werte__hauptsubpos(); 
                
                 CREATE TRIGGER a_350_iu__werte__subposhauptpos
                  -- muß nach Cache aktualisieren sein, da sonst noch alte Werte gesehen werden
                  -- beachte bei Änderungen: belzeil__a_u__totalposwert_hauptsubpos
                  AFTER INSERT OR UPDATE
                    OF p_menge
                       , p_me
                       , p_preis $$|| IFTHEN (tsystem.column_exists( _table_name, 'p_preis_me', _schema_name ), ', p_preis_in_pe, p_preis_me, p_preis_pe', '') ||$$
                                 $$|| IFTHEN (tsystem.column_exists( _table_name, 'p_rabatt', _schema_name ), ', p_rabatt, p_rabatt_gesamt, p_rabatt_able, p_parent_p_id, p_parent_pos', '') ||$$
                                 -- p_parent_p_id, p_parent_pos  >  bachte Zeile darüber 
                                 $$|| IFTHEN (tsystem.column_exists( _table_name, 'p_waer', _schema_name ), ', p_waer, p_waer_kurs', '') ||$$
                                 $$|| IFTHEN (tsystem.column_exists( _table_name, 'p_steu_code', _schema_name ), ', p_steu_code, p_steu_proz', '') ||$$
                       , p_wert_netto, p_wert_abzu_netto          -- abzu > Kopf                       
                       , p_preis_sumsubpos
                    ON $$ || tname || $$
                    FOR EACH ROW
                    --WHEN (NOT new.ag_vkptotalpos) NICHT, da ich eine "Preis enthält Unterposition" - Position in eine andere schieben kann, wodurch sich diese ändern muß
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_350_iu__werte__subposhauptpos();
    
                 CREATE TRIGGER a_350_d__werte__subposhauptpos
                  AFTER DELETE
                  ON $$ || tname || $$
                  FOR EACH ROW
                  WHEN (old.p_parent_p_id IS NOT NULL)
                  EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_350_d__werte__subposhauptpos();
               $$;
              END IF;
              RETURN;
             END $f$ LANGUAGE plpgsql;
           --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__trigger__all__create( _schema_name text, _table_name text ) RETURNS VOID AS $f$
             BEGIN
              -- Basis-Trigger (Tablename, defaults, p_nummer)
               PERFORM TSystem_Wawi.beleg_p__trigger__tablename__create( _schema_name, _table_name );      
               PERFORM TSystem_Wawi.beleg_p__trigger__defaults__create( _schema_name, _table_name );
               PERFORM TSystem_Wawi.beleg_p__trigger__p_nummer__create( _schema_name, _table_name );          
              --
              IF tsystem.column_exists( _table_name , 'p_preis_sumsubpos', _schema_name ) THEN -- p_parent_p_id ; von preisen trennen? 
                 PERFORM TSystem_Wawi.beleg_p__trigger__hauptpossubpos__create(_schema_name, _table_name );
               END IF;
              --
              IF tsystem.column_exists( _table_name , 'p_menge', _schema_name ) THEN -- indicator INHERITS beleg_p__art_menge
                 PERFORM TSystem_Wawi.beleg_p__trigger__menge_uf__create(_schema_name, _table_name );
               END IF;
              --
              IF tsystem.column_exists( _table_name , 'p_wert_netto', _schema_name ) THEN -- indicator INHERITS beleg_p__preise
                 PERFORM TSystem_Wawi.beleg_p__trigger__wert__before__create(_schema_name, _table_name );        
                 PERFORM TSystem_Wawi.beleg_p__trigger__wert__after__create(_schema_name, _table_name ); -- kurs, rund_fakt change
               END IF;
              --
              EXECUTE $$ --Storniert, PicnDoku
                   CREATE TRIGGER b_500_iu__done_storniert
                    BEFORE INSERT OR UPDATE
                    OF p_done, p_storno
                    ON $$ || _schema_name || '.' || _table_name || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__b_500_iu__done_storniert();  
        
                   CREATE TRIGGER a_700_iu__picndoku_keyword -- Picndoku verschlagworten
                    BEFORE INSERT OR UPDATE
                    ON $$ || _schema_name || '.' || _table_name || $$
                    FOR EACH ROW --TODO klärung: wann Verschlagwortung (Ticket und Metastruktur erstellen)
                    EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_700_iu__picndoku_keyword();              
                    $$
              --
              RETURN;
             END $f$ LANGUAGE plpgsql;              
        -- CONSTRAINTS beleg_p : Index, Foreign Key usw.
           CREATE OR REPLACE FUNCTION TSystem_Wawi.beleg_p__constraints__all__create( _schema_name_pos text, _table_name_pos text, _schema_name_kopf text, _table_name_kopf text ) RETURNS VOID AS $f$
           
             DECLARE 
             
                _fqn_kopf text = _schema_name_kopf || '.' || _table_name_kopf;
                _fqn_pos  text = _schema_name_pos || '.' || _table_name_pos;

             BEGIN

              -- 
              EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD CONSTRAINT $$ || _table_name_pos || '__pkey'                 || $$ PRIMARY KEY (p_id) $$;
              -- EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ALTER COLUMN p_id SET DEFAULT nextval('tsystem_wawi.beleg_p_p_id_seq') $$;
              
              EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD CONSTRAINT $$ || _table_name_pos || '__p_k_id_fkey'          || $$ FOREIGN KEY (p_k_id)         REFERENCES $$ || _fqn_kopf || $$ ON DELETE CASCADE $$;          
              EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD CONSTRAINT $$ || _table_name_pos || '__p_parent_p_id_fkey'   || $$ FOREIGN KEY (p_parent_p_id)  REFERENCES $$ || _fqn_pos || $$; -- ON DELETE CASCADE $$;
              --EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD CONSTRAINT $$ || _table_name_pos || '_pos_isnt_parentpos__xtt11104' || $$ CHECK(p_pos IS DISTINCT FROM p_parent_pos) $$; --wird vererbt, da Constraint....
              
              EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD CONSTRAINT $$ || _table_name_pos || '__dbrid_key'            || $$ UNIQUE(dbrid) $$;              
              EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD CONSTRAINT $$ || _table_name_pos || '__p_k_id__pos__unique'  || $$ UNIQUE(p_k_id, p_pos) $$;   
              
              EXECUTE $$ CREATE INDEX  $$ || _table_name_pos || '__p_id_oldstructure'   || $$ ON $$ || _fqn_pos || $$ (p_id_oldstructure) WHERE p_id_oldstructure IS NOT NULL $$;
              EXECUTE $$ CREATE INDEX  $$ || _table_name_pos || '__p_k_nummer'          || $$ ON $$ || _fqn_pos || $$ (p_k_nummer)$$;
              EXECUTE $$ CREATE INDEX  $$ || _table_name_pos || '__p_parent_p_id'       || $$ ON $$ || _fqn_pos || $$ (p_parent_p_id) WHERE p_parent_p_id IS NOT NULL$$;
              
              EXECUTE $$ CREATE INDEX  $$ || _table_name_pos || '__p_k_id'              || $$ ON $$ || _fqn_pos || $$ (p_k_id)$$; -- UNIQUE(p_k_id, p_pos) wird nicht immer ideal genutzt.
                        
              EXECUTE FORMAT('CREATE TRIGGER %I BEFORE INSERT OR UPDATE ON %s FOR EACH ROW EXECUTE PROCEDURE table_modified();', _table_name_pos || '_set_modified', _fqn_pos);
              EXECUTE FORMAT('CREATE TRIGGER %I AFTER DELETE ON %s FOR EACH ROW EXECUTE PROCEDURE table_delete();', _table_name_pos || '_table_detele', _fqn_pos);
              --
     
              IF tsystem.column_exists( _table_name_pos, 'p_aknr', _schema_name_pos ) THEN --indicator INHERITS beleg_p__art
                 EXECUTE $$ CREATE INDEX $$ || _table_name_pos || '__p_aknr' || $$ ON $$ || _fqn_pos || $$ (p_aknr) $$;
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_aknr)         REFERENCES art ON UPDATE CASCADE $$;         
               END IF;
              IF tsystem.column_exists( _table_name_pos, 'p_me', _schema_name_pos ) THEN
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_me)           REFERENCES artmgc ON UPDATE CASCADE $$;
               END IF;             
              IF tsystem.column_exists( _table_name_pos, 'p_preis_me', _schema_name_pos ) THEN   
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_preis_me)     REFERENCES artmgc ON UPDATE CASCADE $$;  
               END IF;
              IF tsystem.column_exists( _table_name_pos, 'p_waer', _schema_name_pos ) THEN
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_waer)         REFERENCES bewa ON UPDATE CASCADE $$;
               END IF;
              IF tsystem.column_exists( _table_name_pos, 'p_steu_code', _schema_name_pos ) THEN
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_steu_code)    REFERENCES steutxt ON UPDATE CASCADE $$;
               END IF;
              --
              IF tsystem.column_exists( _table_name_pos, 'px_an_nr', _schema_name_pos ) THEN --
                 EXECUTE $$ CREATE INDEX $$ || _table_name_pos || '__px_an_nr' || $$ ON $$ || _fqn_pos || $$ (px_an_nr) WHERE px_an_nr IS NOT NULL $$;
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (px_an_nr)        REFERENCES anl $$;
               END IF;  
              IF tsystem.column_exists( _table_name_pos, 'p_ks', _schema_name_pos ) THEN --
                 EXECUTE $$ CREATE INDEX $$ || _table_name_pos || '__p_ks' || $$ ON $$ || _fqn_pos || $$ (p_ks) WHERE p_ks IS NOT NULL $$;
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_ks)            REFERENCES ksv $$;
               END IF;
              --
              -- Todo Klärung -- Bugfix: Belegpos ..._bstat Constraints auskommentiert, da Konflikte mit freier Eingabe im Auftrag bei der Übernahme in Lieferschein (bei Loll passiert, LG)
              IF tsystem.column_exists( _table_name_pos, 'p_bstat1', _schema_name_pos ) AND _fqn_pos = 'TWawi.beleg_p__verkauf' THEN
                 -- TODO bei ldsdok REFERNCES ldsbs oder sowas
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_bstat1)        REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL; $$;
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_bstat2)        REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL; $$;
                 EXECUTE $$ ALTER TABLE $$ || _fqn_pos || $$ ADD FOREIGN KEY (p_bstat3)        REFERENCES auftgbs ON UPDATE CASCADE ON DELETE SET NULL; $$;
              END IF;
              --
              RETURN;
             END $f$ LANGUAGE plpgsql; 
        
        
             
        
        -- 
        -- ################## Abzuschläge ####################
        
        -- FUNCTION TSystem_Wawi.abzu_p__b_050_i__defaults
           CREATE OR REPLACE FUNCTION TSystem_Wawi.abzu_p__b_050_i__defaults() RETURNS TRIGGER AS $$ --
              BEGIN  
                -- Positionsbzeogen
                IF new.az_p_id IS NOT NULL THEN
                 SELECT 
                      p_k_id, COALESCE(new.az_steu_code, p_steu_code), COALESCE(NULLIF(new.az_steu_proz, 0), p_steu_proz)  --NULLIF wegen DEFAULT 0
                      INTO 
                      new.az_k_id, new.az_steu_code, new.az_steu_proz
                 FROM TWawi.beleg_p WHERE p_id = new.az_p_id;
                -- Kopfbezogen
                ELSE
                 SELECT 
                      COALESCE(new.az_steu_code, k_steu_code), COALESCE(NULLIF(new.az_steu_proz, 0), k_steu_proz)  --NULLIF wegen DEFAULT 0
                      INTO 
                      new.az_steu_code, new.az_steu_proz
                 FROM TWawi.beleg_k WHERE k_id = new.az_k_id;
                END IF;
                --
                RETURN new;
              END $$ LANGUAGE plpgsql;  
        -- FUNCTION abzu_p TRIGGER abzu_p__b_320_iu__wert >> Porzentual, PARENT AKTUALISIEREN
           CREATE OR REPLACE FUNCTION TSystem_Wawi.abzu_p__b_320_iu__wert() RETURNS TRIGGER AS $$
              DECLARE kurs NUMERIC;
              BEGIN
               IF new.az_p_id IS NOT NULL THEN -- Kopf oder Positionsbezogen
                  kurs := p_waer_kurs FROM TWawi.beleg_p WHERE p_id = new.az_p_id;
                 ELSE
                  kurs := k_waer_kurs FROM TWawi.beleg_k WHERE k_id = new.az_k_id;
                END IF;
               --
               IF new.az_preis_prozentual IS NOT NULL THEN
                  IF new.az_p_id IS NOT NULL THEN
                     new.az_preis := p_wert_netto * new.az_preis_prozentual/100 FROM twawi.beleg_p WHERE p_id = new.az_p_id;
                   ELSE
                     new.az_preis := k_wert_netto * new.az_preis_prozentual/100 FROM twawi.beleg_k WHERE k_id = new.az_k_id;
                   END IF;
                END IF;
               --
               new.az_wert_netto        := new.az_anzahl * new.az_preis;
               new.az_wert_netto_gwaer  := new.az_wert_netto * kurs;
               new.az_wert_brutto       := new.az_wert_netto * (1 + COALESCE(new.az_steu_proz, 0) / 100);
               new.az_wert_brutto_gwaer := new.az_wert_netto_gwaer * (1 + COALESCE(new.az_steu_proz, 0) / 100);
               -- rund_faktor?
               PERFORM tcache.function_cache_setdirty_1param('beleg_p__pos_wert_calc', new.az_p_id);
               --
               -- PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', new.az_p_id); -- TODO bei Umsetzung Auftrag?
               --
               RETURN new;
              END $$ LANGUAGE plpgsql;
           --    
           CREATE OR REPLACE FUNCTION TSystem_Wawi.abzu_p__a_390_iud__wert__propagate__beleg_x() RETURNS TRIGGER AS $$
              DECLARE r RECORD;
                      my_x_id INTEGER;
              BEGIN
               IF tg_op = 'DELETE' THEN
                  my_x_id := old.az_p_id;
                ELSE
                  my_x_id := new.az_p_id;
               END IF;
               -- Positionsbezogene Abzuschläge
               IF my_x_id IS NOT NULL THEN -- Positions-Id
                   SELECT SUM(COALESCE(az_wert_netto ,0)) AS az_wert_netto, 
                          SUM(COALESCE(az_wert_netto_gwaer, 0)) AS az_wert_netto_gwaer,
                          SUM(COALESCE(az_wert_brutto, 0)) AS az_wert_brutto,
                          SUM(COALESCE(az_wert_brutto_gwaer, 0)) AS az_wert_brutto_gwaer
                          INTO r FROM TSystem_Wawi.abzu_p WHERE az_p_id = my_x_id;
                   --
                   UPDATE TWawi.beleg_p SET p_wert_abzu_netto        = r.az_wert_netto,
                                            p_wert_abzu_netto_gwaer  = r.az_wert_netto_gwaer,
                                            p_wert_abzu_brutto       = r.az_wert_brutto,
                                            p_wert_abzu_brutto_gwaer = r.az_wert_brutto_gwaer
                   
                          WHERE p_id = my_x_id;          
                   -- UPDATE aktualisiert auch beleg_k
                   PERFORM tcache.function_cache_setdirty_1param('beleg_p__pos_wert_calc', my_x_id);
                    --
                    -- PERFORM tcache.function_cache_setdirty_1param('auftg_pos_wert_calc', my_x_id);
               END IF;
               -- Kopfbezogene Abzuschläge
               IF tg_op = 'DELETE' THEN
                  my_x_id := old.az_k_id;
                ELSE
                  my_x_id := new.az_k_id;
               END IF;
               -- 
               IF my_x_id IS NOT NULL THEN -- Kopf-Id
                   SELECT SUM(COALESCE(az_wert_netto ,0)) AS az_wert_netto, 
                          SUM(COALESCE(az_wert_netto_gwaer, 0)) AS az_wert_netto_gwaer,
                          SUM(COALESCE(az_wert_brutto, 0)) AS az_wert_brutto,
                          SUM(COALESCE(az_wert_brutto_gwaer, 0)) AS az_wert_brutto_gwaer
                          INTO r FROM TSystem_Wawi.abzu_p WHERE az_k_id = my_x_id AND az_p_id IS NULL;
                   -- 
                   UPDATE TWawi.beleg_k SET k_wert_abzuk_netto        = r.az_wert_netto,
                                            k_wert_abzuk_netto_gwaer  = r.az_wert_netto_gwaer,
                                            k_wert_abzuk_brutto       = r.az_wert_brutto,
                                            k_wert_abzuk_brutto_gwaer = r.az_wert_brutto_gwaer
                   
                          WHERE k_id = my_x_id;
               END IF;
               --
               RETURN new;
              END $$ LANGUAGE plpgsql;
        -- Diverse Trigger (Kontierung, invalidmessages)
           CREATE OR REPLACE FUNCTION TSystem_Wawi.abzu_p__b_500__abz_id__kontierung() RETURNS TRIGGER AS $$
            BEGIN
              new.az_konto := abz_konto FROM public.abzu WHERE abz_id = new.az_abz_id; --public: sinnlos View in TWawi gleich benannt
              RETURN new;
            END $$ LANGUAGE plpgsql;
            --
           CREATE OR REPLACE FUNCTION TSystem_Wawi.abzu_p__a_700_iu__invalidmessages() RETURNS TRIGGER AS $$
            BEGIN
             IF (SELECT true FROM steutxt WHERE steu_z = new.az_steu_code AND steu_valid_to < current_date) THEN
                IF (new.az_p_id IS NOT NULL AND new.az_steu_code IS DISTINCT FROM (SELECT p_steu_code FROM TSystem_Wawi.beleg_p__preise_steu_brutto WHERE p_id = new.az_p_id)) 
                OR (new.az_k_id IS NOT NULL AND new.az_steu_code IS DISTINCT FROM (SELECT k_steu_code FROM TSystem_Wawi.beleg_k__preise_steu_zahlung WHERE k_id = new.az_k_id))  
                   -- Wenn gleich, hat Kopf bereits Nachricht geworfen
                THEN
                    PERFORM PRODAT_TEXT(15810); --Steuer abgelaufen / Ungültig
                END IF;
             END IF;
             RETURN new;
            END $$ LANGUAGE plpgsql;
        -- TRIGGER CREATE FUNCTION abzu_p__trigger__all__create
           CREATE FUNCTION TSystem_Wawi.abzu_p__trigger__all__create( _schema_name_pos text, _table_name_pos text, _schema_name_kopf text, _table_name_kopf text ) RETURNS VOID AS $f$
           
             DECLARE 
             
                _fqn_kopf text = _schema_name_kopf || '.' || _table_name_kopf;
                _fqn_pos  text = _schema_name_pos || '.' || _table_name_pos;

             BEGIN
             
               -- Trigger an Position zur Aktualisierung von Abzuschlägen
               IF tsystem.column_exists(_table_name_kopf, 'p_preis', _schema_name_kopf) THEN -- Wenn es Abzuschläge gibt, ist immer von einer vollständigen twawi.beleg_p Position auszugehen
                    EXECUTE $$ 
                    CREATE TRIGGER a_400_iu__wert__propagate__abzu_p
                     AFTER INSERT OR UPDATE
                     OF p_menge                      --  Prozentualer Abzuschlag
                        , p_me                       
                        , p_preis, p_preis_in_pe, p_preis_me, p_preis_pe
                        , p_waer, p_waer_kurs        --  Abzuschläge anhand neuem Kurs aktualisieren      
                        , p_steu_code, p_steu_proz   --  Neuer Steuersatz  >  Abzuschläge 
                        , p_wert_netto               --  k_rund_faktor > Abzuschläge
                     ON $$ || _fqn_kopf || $$
                     FOR EACH ROW
                     -- in funktion im WHERE: az_preis_prozentual IS NOT NULL
                     EXECUTE PROCEDURE TSystem_Wawi.beleg_p__a_400_iu__wert__propagate__abzu_p();            
                     $$;
                 END IF;
               --
              EXECUTE $$
                  CREATE TRIGGER b_000_i__tablename--Grundtrigger anhängen<
                    BEFORE INSERT
                    ON $$ || _fqn_pos || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.abzu_p__b_000_i__tablename();
                    
                  CREATE TRIGGER b_050_i__defaults
                    BEFORE INSERT
                    ON $$ || _fqn_pos || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.abzu_p__b_050_i__defaults();
    
                  CREATE TRIGGER b_152_u__abzid
                   BEFORE UPDATE
                   OF az_abz_id
                   ON $$ || _fqn_pos || $$
                   FOR EACH ROW
                   EXECUTE PROCEDURE TSystem_wawi.abzu_p__b_152_u__abzid();
    
                  CREATE TRIGGER a_154_iu__srcabzu_done
                   AFTER INSERT OR UPDATE
                   OF az_source_table, az_source_dbrid
                   ON $$ || _fqn_pos || $$
                   FOR EACH ROW
                   EXECUTE PROCEDURE TSystem_wawi.abzu_p__a_154_iud__srcabzu_done();    
                  CREATE TRIGGER a_154_d__srcabzu_done
                   AFTER DELETE
                   ON $$ || _fqn_pos || $$
                   FOR EACH ROW
                   WHEN (old.az_source_dbrid IS NOT NULL)
                   EXECUTE PROCEDURE TSystem_wawi.abzu_p__a_154_iud__srcabzu_done();    
                   
                    
                  CREATE TRIGGER b_320_iu__wert
                    BEFORE INSERT OR UPDATE
                    OF az_anzahl, az_preis
                       , az_wert_netto --kurs geändert, nur im before, muß nicht rückübertragen werden
                    ON $$ || _fqn_pos || $$
                    FOR EACH ROW 
                    EXECUTE PROCEDURE TSystem_Wawi.abzu_p__b_320_iu__wert();
        
                  CREATE TRIGGER a_390_iuX__wert__propagate__beleg_x -- INSERT OR UPDATE
                    AFTER INSERT OR UPDATE
                    OF az_anzahl, az_preis
                       , az_wert_netto --kurs geändert, nur im before, muß nicht rückübertragen werden
                    ON $$ || _fqn_pos || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.abzu_p__a_390_iud__wert__propagate__beleg_x();
                    
                  CREATE TRIGGER a_390_XXd__wert__propagate__beleg_x -- DELETE
                    AFTER DELETE
                    --OF az_anzahl, az_preis
                    ON $$ || _fqn_pos || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.abzu_p__a_390_iud__wert__propagate__beleg_x() ;
                    
                  --
                  
                  CREATE TRIGGER b_500_iu__abzid__kontierung
                    BEFORE INSERT OR UPDATE
                    OF az_abz_id
                    ON $$ || _fqn_pos || $$
                    FOR EACH ROW
                    EXECUTE PROCEDURE TSystem_Wawi.abzu_p__b_500__abz_id__kontierung();
                    
                  CREATE TRIGGER a_700_iu__invalidmessages
                    AFTER INSERT OR UPDATE
                    OF az_steu_code
                    ON $$ || _fqn_pos || $$
                    FOR EACH ROW
                    WHEN (new.az_steu_code IS NOT NULL)
                    EXECUTE PROCEDURE TSystem_Wawi.abzu_p__a_700_iu__invalidmessages();           
                  $$;
              --
              RETURN;
             END $f$ LANGUAGE plpgsql;              
        -- ABZU Constraints
           CREATE FUNCTION TSystem_Wawi.abzu_p__constraints__all__create(tname VARCHAR, tnamek VARCHAR, tnamep VARCHAR) RETURNS VOID AS $f$
             DECLARE plain_tname VARCHAR; --ohne Schema
                     PosOfSchemaPoint Integer;
             BEGIN
              PosOfSchemaPoint := StrPos(tname, '.');
              IF PosOfSchemaPoint > 0 THEN
                 plain_tname := SubStr(tname, PosOfSchemaPoint + 1, 99);
                ELSE
                 plain_tname := tname; 
               END IF;
              -- 
              EXECUTE $$ ALTER TABLE $$ || tname || $$ ADD CONSTRAINT $$ || plain_tname || '_pkey'                      || $$ PRIMARY KEY (az_id) $$;
              EXECUTE $$ ALTER TABLE $$ || tname || $$ ADD CONSTRAINT $$ || plain_tname || '_az_k_id_fkey'              || $$ FOREIGN KEY (az_k_id)        REFERENCES $$ || tnamek || $$ ON DELETE CASCADE $$;  
              EXECUTE $$ ALTER TABLE $$ || tname || $$ ADD CONSTRAINT $$ || plain_tname || '_az_p_id_fkey'              || $$ FOREIGN KEY (az_p_id)        REFERENCES $$ || tnamep || $$ ON DELETE CASCADE $$;    
             
              EXECUTE $$ ALTER TABLE $$ || tname || $$ ADD CONSTRAINT $$ || plain_tname || '__dbrid_key'                || $$ UNIQUE(dbrid) $$; 

              EXECUTE $$ CREATE INDEX  $$ || plain_tname || '__az_p_id' || $$ ON $$ || tname || $$ (az_p_id) WHERE az_p_id IS NOT NULL $$;
              EXECUTE $$ CREATE INDEX  $$ || plain_tname || '__az_k_id' || $$ ON $$ || tname || $$ (az_k_id)$$;
              
              EXECUTE FORMAT('CREATE TRIGGER %I BEFORE INSERT OR UPDATE ON %s FOR EACH ROW EXECUTE PROCEDURE table_modified();', plain_tname || '_set_modified', tname);
              EXECUTE FORMAT('CREATE TRIGGER %I AFTER DELETE ON %s FOR EACH ROW EXECUTE PROCEDURE table_delete();', plain_tname || '_table_detele', tname);
              --
              EXECUTE $$ ALTER TABLE $$ || tname || $$ ADD CONSTRAINT $$ || plain_tname || '_az_abz_id_fkey'            || $$ FOREIGN KEY (az_abz_id)        REFERENCES public.abzu ON UPDATE CASCADE $$;
              EXECUTE $$ ALTER TABLE $$ || tname || $$ ADD CONSTRAINT $$ || plain_tname || '_az_steu_code_fkey'         || $$ FOREIGN KEY (az_steu_code)     REFERENCES public.steutxt ON UPDATE CASCADE $$;                  
              --  
              RETURN;
             END $f$ LANGUAGE plpgsql; 
        
        
        --
        
        -- ################## [00] Warenwirtschaft-Grundtabellen: Trigger, Constraints
        
         SELECT TSystem_Wawi.beleg_k__constraints__all__create('twawi','beleg_k'); 
         SELECT TSystem_Wawi.beleg_k__trigger__all__create('twawi','beleg_k');
        
         SELECT  TSystem_Wawi.beleg_p__constraints__all__create('twawi','beleg_p', 'twawi','beleg_k');
         SELECT  TSystem_Wawi.beleg_p__trigger__all__create('twawi','beleg_p');
        
         SELECT TSystem_Wawi.abzu_p__constraints__all__create('twawi.abzu_p', 'twawi.beleg_k', 'twawi.beleg_p');
         SELECT TSystem_Wawi.abzu_p__trigger__all__create('twawi','abzu_p', 'twawi','beleg_p');   
